// public/js/database/compat/health.js

export const HEALTH_cAjna = {
    
    // 1. МАГ
    "1": {
        positive: `Ваша ментальная связь становится инструментом созидания реальности. Вы направляете интуицию и воображение точно в цель, как архитекторы — проектируя общее видение будущего. 
        Создаёте ритуалы ментальной синхронизации: совместные визуализации, обсуждение снов, медитации на открытие третьего глаза. 
        Ваше мышление не хаотично — оно видит закономерности и работает с ними. Проблемы с пониманием (как ментальные, так и интуитивные) отступают перед вашей объединённой волей к ясности. 
        Вы — маги ментального здоровья, превращающие непонимание в глубину, а иллюзии — в прозрение.`,
        
        negative: `Ваша ментальная связь превращается в манипуляцию восприятием. Один использует интуицию как оружие: «Я знаю, о чём ты думаешь». 
        Доверие становится игрой в угадайку, инсайты — инструментом контроля. Вы играете в телепатов, ставя друг другу ментальные «диагнозы» и назначая интеллектуальные «процедуры». 
        Непонимание усугубляется от напряжения — вы лечите не мышление, а свой проект идеального взаимопонимания. Третий глаз закрывается, а не открывается. 
        Ваша связь похожа на сеанс гипноза без согласия — страшно, но почему-то продолжаете.`,
        
        advice: `Создайте «договор ментальной честности»: запретите фразу «я знаю, что ты на самом деле думаешь». 
        Практикуйте «медитацию пустого ума»: просто сидите рядом, наблюдая мысли без анализа и комментариев. 
        Ведите «журнал инсайтов»: записывайте, какие слова и идеи действительно проясняют понимание, а какие запутывают. 
        Направляйте вашу магию на совместное видение, а не на чтение мыслей.`
    },

    // 2. ЖРИЦА
    "2": {
        positive: `Ваша ментальная связь уходит корнями в глубины подсознания. Вы чувствуете невысказанные мысли друг друга без слов, как будто ваши умы соединены тайными каналами. 
        Создаёте пространство молчаливого понимания — иногда достаточно просто знать, не объясняя. Сны и интуитивные прозрения становятся проводниками в тайные комнаты вашей близости. 
        Вы доверяете внутреннему знанию больше, чем внешним фактам — и часто оказываетесь правы. Ваше взаимопонимание — это тихий разговор душ, который яснее любых слов. 
        Вы — жрицы и жрецы храма ваших умов, хранящие тайны друг друга и превращающие их в мудрость.`,
        
        negative: `Ваша ментальная связь тонет в невысказанном. Вы молча догадываетесь о мыслях партнёра, боясь нарушить священную тишину. Непонимание прогрессирует в атмосфере тайн и намёков. 
        Интуиция становится ритуалом молчания — вы боитесь говорить о догадках, чтобы «не осквернить» вашу связь. Умы отдаляются, хотя физически рядом. 
        Вы создаёте культ недоговорённостей, где ясность — это нечто постыдное, что нужно скрывать даже от самого близкого. 
        Ваша связь похожа на два айсберга — на поверхности холод и тишина, а под водой — невысказанные мысли.`,
        
        advice: `Установите «правило одного предположения»: если слишком страшно говорить напрямую, начинайте с «Мне кажется…». 
        Практикуйте «письма от ума»: пишите друг другу о своих догадках и страхах, и обменивайтесь, не читая при всех. 
        Создайте «шкатулку ментальных тайн» — храните там записки о самых странных инсайтах, раз в месяц доставайте и обсуждайте одну. 
        Научитесь расшифровывать молчание, не превращая его в стену.`
    },

    // 3. ИМПЕРАТРИЦА
    "3": {
        positive: `Ваша ментальная связь цветёт как сад ясности и принятия. Вы превращаете непонимание в возможность проявить терпение в самых простых вещах: объяснить ещё раз, выслушать, дать время на осмысление. 
        Создаёте атмосферу ментального уюта, где можно быть непонятливым без стыда. Когнитивные трудности становятся почвой, на которой растёт ваше взаимное терпение. 
        Вы — садовники ваших умов, поливающие их вниманием и уважением к разности мышления. Понимание здесь — не мгновенное озарение, а ежедневные маленькие усилия, которые говорят: «Я пытаюсь тебя понять». 
        Умы расцветают даже в непонимании, потому что чувствуют себя в безопасности.`,
        
        negative: `Ваша ментальная связь становится удушающей опекой мышления. Один превращает объяснения в контроль: «Я лучше знаю, что ты имел в виду». 
        Понимание становится обязанностью. Непонимание используется как способ привязать к себе, лишить самостоятельности мысли. 
        Вы создаёте отношения учителя и ученика, где взрослый человек чувствует себя глупым. Умы задыхаются от избытка «объяснений» — хочется сбежать, но некуда. 
        Ваша связь похожа на теплицу, где растения вянут от недостатка свободы роста. Вы выращиваете не понимание, а зависимость.`,
        
        advice: `Создайте «меню объяснений»: пусть тот, кто не понимает, сам выбирает из списка, какой способ разъяснения нужен сегодня. 
        Практикуйте «день равноправия в незнании»: даже если один не понимает, другой тоже имеет право на замешательство и вопросы. 
        Введите правило «спроси, прежде чем объяснить»: прежде чем разъяснять что-то, спрашивайте: «Тебе нужно, чтобы я объяснил?». 
        Помните: истинное понимание даёт свободу мысли, а не отнимает её.`
    },

    // 4. ИМПЕРАТОР
    "4": {
        positive: `Ваша ментальная связь строится на надёжности и структуре мышления. Вы создаёте систему взаимопонимания: чёткие договорённости о значении слов, правила обсуждения, ментальные карты общих взглядов. 
        Понимание проявляется как ясность и предсказуемость — вы становитесь крепостью логики друг для друга. Когнитивные проблемы встречают организованное сопротивление, без паники и суеты. 
        Вы — правители вашего общего ментального пространства, устанавливающие границы и правила, которые защищают умы. 
        Умы чувствуют себя в безопасности, потому что знают: партнёр мыслит последовательно. Доверие здесь — это не сантименты, а верность договорённостям о значении слов.`,
        
        negative: `Ваша ментальная связь превращается в диктатуру мышления. Один берёт на себя роль командира мыслей, другой становится подчинённым. 
        Понимание подменяется дисциплиной. Непонимание используется как оправдание для тотального контроля над тем, как партнёр должен думать. 
        Вы создаёте иерархию, где у того, кто не понял, нет права голоса. Умы замирают от страха нарушить правила мышления. 
        Ваша связь похожа на армию, где собственные мысли считаются мятежом. Вы строите не крепость, а тюрьму для умов. Понимание умирает под гнётом долженствований.`,
        
        advice: `Создайте «конституцию понимания»: пропишите права и обязанности каждого в обсуждениях, включая право на непонимание. 
        Практикуйте «совет двух императоров»: все трактовки и значения принимаются единогласно. 
        Введите «день ментальной анархии»: раз в месяц отменяйте все правила общения и просто говорите, как чувствуете. 
        Помните: даже император иногда должен слушать не логику, а интуицию.`
    },

    // 5. ИЕРОФАНТ
    "5": {
        positive: `Ваша ментальная связь освящена общими духовными истинами. Вы находите в непонимании высший смысл — возможность для роста сознания, испытание вашего взаимного доверия. 
        Медитируете вместе, ищете кармические причины ментальных блоков, обсуждаете духовные тексты. Понимание становится служением — вы видите в партнёре не просто собеседника, а проводника божественной мудрости. 
        Когнитивные трудности воспринимаются как уроки, которые нужно пройти с смирением. Вы — духовные наставники друг для друга, помогающие найти свет истины в темноте непонимания. 
        Умы соединяются на уровне духа, и это даёт силы переносить интеллектуальные разногласия.`,
        
        negative: `Ваша ментальная связь становится догматичной. Один начинает поучать другого, ища «греховные» причины непонимания. 
        Понимание подменяется морализаторством. Непонимание рассматривается как наказание за неправильные мысли или недостаток веры. 
        Вы создаёте культ ментальной чистоты, где тот, кто не понял, должен «очистить сознание». Умы сжимаются от чувства вины. 
        Ваша связь похожа на инквизицию, где понимание conditional — только если ты «достоин». Вы строите не храм, а судилище для умов. Духовность становится оружием интеллектуального насилия.`,
        
        advice: `Создайте «синтез духовности и реальности»: духовные прозрения должны сопровождаться простыми человеческими объяснениями. 
        Практикуйте «ритуал безоценочного принятия мыслей»: говорите друг другу: «Ты имеешь право не понимать, это не твоя вина». 
        Введите «день светского общения»: раз в неделю запрещайте все духовные разговоры и просто говорите о бытовых вещах. 
        Помните: истинная духовность принимает, а не осуждает.`
    },

    // 6. ВЛЮБЛЕННЫЕ
    "6": {
        positive: `Ваша ментальная связь — это гармония и взаимный выбор понимать друг друга. Вы выбираете пытаться понять партнёра каждый день, даже когда его мысли кажутся чужими, даже когда логика различается. 
        Создаёте баланс между ясностью и тайной — не требуете полной прозрачности, но и не строите стен. Когнитивные различия становятся точкой ещё большего интереса друг к другу. 
        Вы — два ума, работающие в унисон, и этот резонанс проясняет. Принятие безусловно — вы хотите понимать друг друга не только когда мысли совпадают, но и когда расходятся, потому что принимаете целиком. 
        Умы раскрываются навстречу, потому что знают: их мысли примут любыми. Вы строите отношения как вечный выбор в пользу попытки понять.`,
        
        negative: `Ваша ментальная связь парализована вечным выбором интерпретации. Вы не можете решить, как понимать слова партнёра, и застреваете в нерешительности. 
        Понимание становится испытанием, которое вы не проходите, потому что боитесь сделать неправильный выбор трактовки. Вы создаёте идеализированную картину, где непонимание — это помеха. 
        Умы замирают в страхе разрушить идиллию полного совпадения. Ваша связь похожа на двух людей на перепутье интерпретаций, которые так и не могут выбрать дорогу. 
        Вы строите не гармонию, а перманентные сомнения в правильности понимания. Доверие становится проблемой, а не решением.`,
        
        advice: `Установите «правило простого уточнения»: каждый день, когда возникает непонимание, задавайте один уточняющий вопрос без оценки. 
        Практикуйте «голосование сердца в спорах»: закройте глаза, положите руку на сердце партнёра и спросите: «Что он на самом деле хочет сказать?». 
        Создайте «карту безопасного непонимания»: определите, какие темы можно временно оставить без полной ясности. 
        Помните: иногда понимание — это не между «правильно» и «неправильно», а между «сейчас» и «позже».`
    },

    // 7. КОЛЕСНИЦА
    "7": {
        positive: `Ваша ментальная связь — это движущая сила, которая помогает преодолеть непонимание. Вы заряжаете друг друга энергией и оптимизмом в поиске ясности, не позволяете унывать от когнитивных разногласий. 
        Создаёте динамику взаимопонимания: вместе ищете новые слова, изучаете методы коммуникации, ставите цели ясности. Проблемы с пониманием воспринимаются как препятствия, которые вы преодолеваете вместе. 
        Вы — команда, мчащаяся на колеснице любознательности к ясности. Умы работают в такт общему движению. Понимание здесь — это не пассивное состояние, а активное действие. 
        Вы строите отношения как совместный проект, где непонимание — всего лишь очередной вызов.`,
        
        negative: `Ваша ментальная связь превращается в гонку за пониманием. Вы требуете от партнёра немедленной ясности, не даёте времени на осмысление. 
        Понимание становится соревнованием: кто больше объяснил, кто больше понял. Вы создаёте атмосферу постоянного напряжения, где нельзя быть непонятливым. 
        Умы устают от этой вечной гонки. Ваша связь похожа на две лошади, запряжённые в одну колесницу и рвущиеся в разные стороны к разным истинам. 
        Вы строите не команду, а конкурентов в понимании. Ясность становится ещё одним стресс-фактором.`,
        
        advice: `Создайте «контрольные точки отдыха для ума»: в вашем общении обязательно включайте темы, где не нужно ничего понимать, просто быть. 
        Практикуйте «совместное торможение»: когда один чувствует перегруз от попыток понять, другой поддерживает решение замедлиться. 
        Ведите «дневник ментальных достижений»: отмечайте не только моменты полного понимания, но и моменты, когда согласились не понимать друг друга. 
        Помните: иногда для ясности нужно остановиться и просто слушать без цели понять.`
    },

    // 8. СИЛА
    "8": {
        positive: `Ваша ментальная связь укрощает страх быть непонятым. Вы не боитесь проявлять глупость, признаваться в непонимании, злиться на сложные мысли партнёра. 
        Создаёте пространство, где можно выпустить нарушу любые интеллектуальные эмоции без осуждения. Когнитивные трудности становятся учителями, показывающими, как общаться по-настоящему. 
        Вы — укротители своих ментальных демонов, и ваше взаимопонимание — это безопасное поле для битвы с внутренними страхами неясности. Умы укрепляются, проходя через испытания взаимного непонимания вместе. 
        Доверие здесь — это не отсутствие споров о смыслах, а умение проходить через них, становясь понятнее друг другу.`,
        
        negative: `Ваша ментальная связь превращается в силовую борьбу за истину. Вы сражаетесь друг с другом за правильность интерпретации, используя непонимание как оружие. 
        Понимание становится полем битвы, где каждый пытается доказать свою правоту. Вы создаёте динамику умного и глупого. 
        Умы покрываются шрамами от взаимных обвинений в тупости. Ваша связь похожа на двух гладиаторов, которые режут друг друга словами, чтобы доказать свою интеллектуальную силу. 
        Вы строите не безопасное пространство, а арену для выяснения, кто умнее. Доверие становится пыткой.`,
        
        advice: `Создайте «договор о перемирии в спорах о смыслах»: во время острого непонимания все споры о правильности замораживаются. 
        Практикуйте «объятие ума»: обнимайте друг друга так крепко, как можете, и шепчите: «Мы поймём друг друга, просто не сейчас». 
        Введите правило «безопасного слова в интеллектуальных спорах»: слово, которое сразу прекращает любой спор о значениях. 
        Помните: истинная сила ума — в умении быть глупым вместе.`
    },

    // 9. ОТШЕЛЬНИК
    "9": {
        positive: `Ваша ментальная связь уважает потребность в уединении мысли. Вы понимаете, что иногда для прояснения нужно побыть наедине со своими размышлениями, и не навязываете немедленных объяснений. 
        Создаёте пространство тихого понимания — можно быть рядом, не требуя немедленной ясности. Когнитивные трудности становятся временем для внутренней работы мысли, и вы уважаете этот процесс. 
        Вы — два отшельника, которые нашли друг в друге тихую гавань для своих мыслей. Умы отдыхают в этой тишине. Понимание здесь — это не постоянные разговоры, а глубинное знание, что партнёр осмысливает в своём темпе. 
        Вы строите отношения как два отдельных, но связанных мира мысли.`,
        
        negative: `Ваша ментальная связь застывает в изоляции мышления. Вы разбегаетесь по своим углам и перестаёте пытаться понять друг друга. Непонимание становится оправданием для ментальной дистанции. 
        Доверие становится одиноким — каждый думает в своём коконе. Вы создаёте два параллельных мира мысли, которые почти не пересекаются. 
        Умы замерзают от недостатка ментального тепла. Ваша связь похожа на две одинокие планеты, вращающиеся каждая в своей орбите мышления. 
        Вы строите не гавань, а ледяную пустыню, где каждый умирает от одиночества мысли.`,
        
        advice: `Установите «ритуал соединения после уединения мысли»: если один ушёл в себя, он обязуется вернуться к общению через оговоренное время. 
        Практикуйте «параллельное мышление»: находитесь в одной комнате, каждый думает о своём, но чувствуете поддержку просто от присутствия другого мыслящего существа. 
        Создайте «систему сигналов для ума»: определите знак, который означает «мне нужно побыть со своими мыслями» и «я готов к ментальному контакту». 
        Помните: даже отшельник иногда нуждается в собеседнике.`
    },

    // 10. КОЛЕСО ФОРТУНЫ
    "10": {
        positive: `Ваша ментальная связь принимает взлёты и падения понимания как естественный цикл. Вы не паникуете при обострениях непонимания и не расслабляетесь в моменты ясности, а адаптируетесь к изменениям в общении. 
        Создаёте ритм взаимопонимания, соответствующий фазам вашей ментальной синхронизации. Проблемы с пониманием воспринимаются как временные неудачи в большой игре под названием общение. 
        Вы — игроки, которые делают ставки на доверие и выигрывают, даже когда проигрывают в ясности. Умы учатся быть гибкими. 
        Понимание здесь — это не постоянная ясность, а умение держаться вместе в любую погоду общения.`,
        
        negative: `Ваша ментальная связь становится заложницей удачи в понимании. Вы понимаете друг друга только в хорошие периоды, а в непонимании отдаляетесь. 
        Доверие зависит от обстоятельств — сегодня есть, завтра нет. Вы создаёте отношения, которые рушатся при первом серьёзном непонимании. 
        Умы не чувствуют надёжности. Ваша связь похожа на рулетку — никогда не знаешь, поймёте ли вы друг друга завтра. 
        Вы строите не команду, двух одиночек, которые вместе только пока везёт с пониманием. Доверие становится лотереей.`,
        
        advice: `Создайте «карту циклов понимания»: отмечайте периоды, чтобы предсказывать сложные фазы в общении и готовиться к ним эмоционально. 
        Практикуйте «ритуал постоянства доверия»: каждый день, независимо от уровня понимания, делайте одно маленькое проявление доверия. 
        Введите «день безусловного принятия мыслей»: раз в неделю принимайте мысли друг друга специально, даже если ничего не понимаете. 
        Помните: колесо фортуны в понимании вращают не только обстоятельства, но и ваше намерение понять.`
    },

    // 11. СПРАВЕДЛИВОСТЬ
    "11": {
        positive: `Ваша ментальная связь стремится к балансу и справедливости в общении. Вы взвешиваете ментальные потребности каждого и находите золотую середину между ясностью и тайной. 
        Создаёте систему взаимопонимания, где никто не остаётся в интеллектуальном минусе. Когнитивные трудности воспринимаются как задача, которую нужно решить совместно и объективно. 
        Вы — судьи ваших мыслей, которые стараются быть беспристрастными. Умы чувствуют, что их слышат и учитывают. 
        Доверие здесь — это не хаос догадок, а разумное партнёрство, основанное на взаимном уважении к разности мышления.`,
        
        negative: `Ваша ментальная связь превращается в суд над мыслями. Вы подсчитываете, кто кому сколько должен в интеллектуальном плане, требуете компенсаций за непонимание. 
        Доверие становится сделкой: «Я тебе объяснил, теперь ты мне обязан понять». Вы создаёте атмосферу взаимных претензий по поводу ясности. 
        Умы страдают от чувства несправедливости в распределении усилий по пониманию. Ваша связь похожа на зал суда, где нет адвокатов, только прокуроры. 
        Вы строите не партнёрство, а бухгалтерию мыслей. Понимание становится обязательством, а не даром.`,
        
        advice: `Создайте «договор о взаимной амнистии в непонимании»: заранее договоритесь, что в периоды когнитивных трудностей не будете вести счёт. 
        Практикуйте «безусловное объяснение»: иногда объясняйте просто потому, что хотите, без ожидания, что партнёр обязательно поймёт. 
        Введите «день благодарности за попытку понять»: раз в неделю благодарите друг друга за все попытки понять, без оценок «достаточно/недостаточно». 
        Помните: в понимании, как и в справедливости, иногда милосердие важнее равенства.`
    },

    // 12. ПОВЕШЕННЫЙ
    "12": {
        positive: `Ваша ментальная связь находит новые глубины в ограничениях понимания. Вы используете вынужденную паузу в ясности, чтобы увидеть мышление партнёра с новой стороны. 
        Создаёте пространство, где можно просто не понимать, без необходимости немедленно прояснять. Когнитивные трудности становятся учителями, которые учат общаться по-новому. 
        Вы — два повешенных, которые, вися вниз головой в непонимании, видят мир мыслей перевёрнутым и находят в этом свою прелесть. Умы открываются в беспомощности понять. 
        Доверие здесь — это не действие по выяснению, а состояние, которое можно просто переживать вместе, даже не понимая до конца.`,
        
        negative: `Ваша ментальная связь застывает в жертвенности непониманию. Один полностью растворяется в своей непонятности, другой — в роли мученика, пытающегося понять. 
        Доверие становится культом страдания от неясности. Вы создаёте отношения, где непонимание — центральная тема, а всё остальное — фон. 
        Умы привыкают к этой роли и боятся ясности. Ваша связь похожа на два трупа, висящие на одном дереве непонимания. 
        Вы строите не новую перспективу, а могилу для вашего общения. Доверие становится способом легализовать ментальное страдание.`,
        
        advice: `Установите «временные рамки для паузы в понимании»: период пассивного принятия непонимания не должен длиться больше определённого срока. 
        Практикуйте «смену перспективы в спорах»: лягте на пол в неудобной позе и смотрите на комнату по-новому, обсуждая, что видите, не пытаясь понять мнение другого. 
        Создайте «карту озарений в непонимании»: записывайте инсайты, которые приходят в состоянии «подвешенности» смыслов. 
        Помните: повешенный в итоге снимается с перекладины — готовьтесь к моменту прояснения вместе.`
    },

    // 13. СМЕРТЬ
    "13": {
        positive: `Ваша ментальная связь способна пережить смерть старых паттернов общения. Вы используете непонимание как точку радикального обновления способов объясняться. 
        Отпускаете старые обиды из-за неправильных трактовок, меняете привычные сценарии обсуждения. Когнитивные трудности становятся ритуалом перехода к новой фазе взаимопонимания. 
        Вы — два феникса, которые сгорают в огне непонимания, чтобы возродиться с обновлёнными способами коммуникации. Доверие очищается от всего наносного. 
        Умы умирают для старых интерпретаций и рождаются для новых. Вы строите отношения на пепелище прошлых недопониманий, но это делает ваше общение прочнее.`,
        
        negative: `Ваша ментальная связь становится фаталистичной. Вы видите в непонимании конец всему и впадаете в отчаяние. 
        Доверие превращается в предсмертную агонию общения. Вы создаёте атмосферу безысходности, где любой намёк на будущее взаимопонимание кажется кощунством. 
        Умы умирают раньше, чем находится общий язык. Ваша связь похожа на похоронную процессию, которую вы проводите при живом партнёре, с которым не можете понять друг друга. 
        Вы строите не новое, а могилу для вашего общения. Доверие становится репетицией смерти взаимопонимания.`,
        
        advice: `Создайте «ритуал прощания со старыми интерпретациями»: символически похороните те трактовки слов, которые больше не служат. 
        Практикуйте «медитацию на понимание после смерти непонимания»: представляйте, как будете общаться после прояснения. 
        Введите «день жизни в общении»: раз в неделю запрещайте говорить о непонимании, общайтесь только на темы, где ясность есть. 
        Помните: смерть старого способа понимать — необходимое условие для рождения нового.`
    },

    // 14. УМЕРЕННОСТЬ
    "14": {
        positive: `Ваша ментальная связь находит золотую середину между крайностями. Вы не впадаете в гиперобъяснение, но и не отдаляетесь, находите тот уровень ясности, который исцеляет общение. 
        Создаёте гармоничную смесь разных подходов к взаимопониманию. Когнитивные трудности воспринимаются как дисбаланс, который можно исправить мягкой корректировкой общения. 
        Вы — алхимики вашего доверия, смешивающие противоположности в нужных пропорциях. Умы чувствуют себя в равновесии. 
        Понимание здесь — это не полная прозрачность и не полная тайна, а тёплая, устойчивая связь, которая даёт опору в трудные времена общения.`,
        
        negative: `Ваша ментальная связь становится вялой и компромиссной. Вы не можете определиться, как понимать друг друга, и останавливаетесь на чём-то среднем, что не удовлетворяет никого. 
        Доверие разбавляется страхом сделать что-то не так в интерпретации. Вы создаёте атмосферу «ни рыба ни мясо», где есть попытки понять, но без души. 
        Умы тонут в этой неопределённости. Ваша связь похожа на тёплую воду — не лечит и не калечит общение, просто есть. 
        Вы строите не гармонию, а болото, где всё медленно тонет в полупонимании. Доверие становится обязанностью, которую выполняют по минимуму.`,
        
        advice: `Создайте «шкалу умеренности в понимании»: от 0 (полное непонимание) до 10 (слияние мыслей) и стремитесь к 5-7. 
        Практикуйте «день крайностей в общении»: один день объясняйте всё максимально подробно, другой — говорите только намёками, потом найдите середину. 
        Введите правило «обоюдного удовлетворения от понимания»: ищите такие формы объяснений, которые комфортны обоим. 
        Помните: умеренность — это не середина между «хочу понять» и «не хочу», а гармония между «могу понять» и «нужно понять».`
    },

    // 15. ДЬЯВОЛ
    "15": {
        positive: `Ваша ментальная связь принимает тёмные стороны непонимания. Вы не отрицаете страх быть непонятым, гнев на сложные мысли, отчаяние от невозможности объясниться, а используете их энергию для укрепления связи. 
        Создаёте пространство, где можно говорить о самых запретных мыслях: «Мне нравится, когда ты меня не понимаешь», «Мне страшно, что ты поймёшь меня слишком хорошо». 
        Когнитивные трудности становятся учителями, которые показывают вам теневые стороны вашего общения. Вы — два демона, которые укротили свою тьму непонимания и сделали её частью связи. 
        Умы становятся целостными, принимая и свет ясности, и тень непонимания. Доверие здесь — это не только радость от понимания, но и способность выдерживать вместе самые трудные моменты неясности.`,
        
        negative: `Ваша ментальная связь попадает в плен к тёмным сторонам непонимания. Вы начинаете наслаждаться драмой неясности, превращая общение в театр недопонимания. 
        Доверие становится игрой в умного и глупого. Вы создаёте созависимые отношения, где непонимание — клей, который держит вас вместе. 
        Умы привыкают к этой токсичной динамике. Ваша связь похожа на ад, который вы построили вместе из недопонимания и теперь не можете из него выйти. 
        Вы строите не целостность, а адскую машину взаимного ментального уничтожения. Доверие становится болезнью.`,
        
        advice: `Создайте «договор с тенью непонимания»: определите, какие тёмные мысли о непонимании можно выражать, а какие лучше оставить при себе. 
        Практикуйте «ритуал освобождения от ролей»: символически снимите с себя роли «непонятливый» и «всепонимающий». 
        Введите «час света в общении»: каждый день выделяйте время для разговоров о чём-то простом и ясном. 
        Помните: даже дьявол непонимания когда-то был ангелом ясности — найдите в своей тени искру света.`
    },

    // 16. БАШНЯ
    "16": {
        positive: `Ваша ментальная связь способна выдержать крушение иллюзий о полном понимании. Когда непонимание разрушает ваши представления о идеальном общении, вы не разбегаетесь, а находите в этом возможность для роста. 
        Создаёте новую, более честную и прочную связь на руинах старых ожиданий ясности. Когнитивные трудности становятся молниями, которые освещают истинную суть вашего доверия. 
        Вы — два строителя, которые после землетрясения непонимания начинают строить новый дом общения, более устойчивый к бурям разногласий. Умы очищаются от всего наносного. 
        Доверие здесь — это не красивая картинка полного совпадения мыслей, а реальность, которую вы принимаете и продолжаете доверять, даже когда она не идеальна.`,
        
        negative: `Ваша ментальная связь рушится при первом серьёзном непонимании. Вы обвиняете друг друга в неясности, впадаете в панику, разбегаетесь по углам. 
        Доверие оказывается иллюзией, которая не выдерживает давления реальности разного мышления. Вы создаёте атмосферу катастрофы, где любой конфликт из-за непонимания кажется концом света. 
        Умы ломаются от взаимных обвинений. Ваша связь похожа на карточный домик, который рухнул от первого дуновения ветра непонимания. 
        Вы строите не новый дом, а руины, в которых каждый хоронит свои надежды на понимание в одиночку. Доверие становится воспоминанием о чём-то, что могло бы быть.`,
        
        advice: `Создайте «план действий в кризисе непонимания»: заранее обсудите, как будете поддерживать друг друга в трудные времена общения. 
        Практикуйте «медитацию на руинах взаимопонимания»: сядьте спина к спине и представьте, что всё рухнуло, а у вас осталась только эта точка соприкосновения тел. 
        Введите правило «одного дня без катастрофы непонимания»: раз в неделю запрещайте драматизировать и рассматривайте непонимание как временную трудность. 
        Помните: после разрушения Башни взаимопонимания всегда открывается новый вид — ищите его вместе.`
    },

    // 17. ЗВЕЗДА
    "17": {
        positive: `Ваша ментальная связь освещается надеждой и верой в понимание. Даже в самой тяжёлой неясности вы находите в себе силы верить в лучшее и поддерживать эту веру в партнёре. 
        Создаёте ритуалы, которые напоминают о свете в конце туннеля непонимания: мечтаете вместе о будущем ясном общении, смотрите на звёзды, говорите о том, что будет после прояснения. 
        Когнитивные трудности становятся тёмным небом, на котором особенно ярко горят звёзды вашего доверия. Вы — два звёздных путешественника, которые даже в ночи непонимания не теряют курс к ясности. 
        Умы согреваются этой надеждой. Доверие здесь — это не отрицание реальности непонимания, а умение видеть свет даже в самой глубокой тьме неясности.`,
        
        negative: `Ваша ментальная связь витает в облаках иллюзий о понимании. Вы отрицаете серьёзность непонимания, прикрываясь красивыми фразами о любви и свете. 
        Доверие становится побегом от реальности разного мышления. Вы создаёте мир фантазий, где нет места когнитивным трудностям и неясностям. 
        Умы отрываются от земли и парят в выдуманном мире полного совпадения мыслей. Ваша связь похожа на красивую сказку, под которой скрывается запущенное непонимание. 
        Вы строите не путь к звёздам ясности, а воздушный замок, который рухнет при первом столкновении с реальностью разного мышления. Доверие становится наркотиком, который помогает не видеть правды.`,
        
        advice: `Создайте «алтарь надежды и реальности в понимании»: на одной стороне разместите символы ваших мечтаний о ясном общении, на другой — факты о ваших когнитивных различиях. 
        Практикуйте «звёздный час»: час в день предавайтесь мечтам о полном понимании, остальное время общайтесь реалистично, принимая непонимание. 
        Введите правило «одной горькой правды в день»: каждый день говорите одну неприятную правду о непонимании, а потом находите один луч надежды на ясность. 
        Помните: звёзды ясности светят, но чтобы добраться до них, нужно идти по земле непонимания.`
    },

    // 18. ЛУНА
    "18": {
        positive: `Ваша ментальная связь основана на интуиции и принятии неопределённости в понимании. Вы доверяете внутренним ощущениям больше, чем внешним словам. 
        Создаёте пространство, где можно делиться самыми иррациональными догадками и снами, связанными с непониманием. Когнитивные трудности становятся проводниками в подсознание. 
        Вы — два медиума, которые слышат голоса своих интуиций и следуют им. Умы общаются на языке символов и ощущений. 
        Доверие здесь — это не логика, а поток чувств, который иногда противоречит разуму, но ведёт к глубине взаимопонимания. Вы строите отношения как плавание по морю интуиции с доверием к внутреннему компасу.`,
        
        negative: `Ваша ментальная связь тонет в страхах и иллюзиях о непонимании. Вы видите опасности в словах партнёра там, где их нет, и подозреваете друг друга в скрытых смыслах. 
        Доверие становится лабиринтом подозрений и догадок. Вы создаёте атмосферу постоянной неопределённости, где никогда не знаете, что на самом деле имеет в виду партнёр. 
        Умы путаются в этом тумане. Ваша связь похожа на блуждание в потёмках, где каждый шаг в интерпретации может быть ошибкой. 
        Вы строите не внутренний компас, а лабиринт, из которого не можете найти выход к ясности. Доверие становится источником тревоги, а не успокоения.`,
        
        advice: `Создайте «дневник страхов и фактов в понимании»: слева записывайте все страхи, связанные с непониманием, справа — объективные данные о том, что было сказано. 
        Практикуйте «ритуал заземления в общении»: вместе опускайте босые ноги на пол, дышите и называйте три реальных слова, которые сказал партнёр. 
        Введите «световой режим для разговоров»: в тёмное время суток не принимайте важных решений о значениях слов. 
        Помните: луна понимания светит отражённым светом — ищите источник ваших интерпретаций.`
    },

    // 19. СОЛНЦЕ
    "19": {
        positive: `Ваша ментальная связь сияет ясностью и принятием различий. Вы встречаете непонимание с оптимизмом и верой в лучшее, и эта энергия передаётся партнёру. 
        Создаёте атмосферу тепла и света в общении, где даже в непонимании можно находить моменты ясности. Когнитивные трудности воспринимаются как временные облака, которые не могут затмить ваше солнце доверия. 
        Вы — два солнца, которые, даже когда одно затмевается непониманием, другое светит за двоих. Умы согреваются этой взаимной поддержкой. 
        Доверие здесь — это не отрицание трудностей в понимании, а умение видеть хорошее даже в самой сложной ситуации общения. Вы строите отношения как путь к свету ясности, даже если временно находитесь в тени непонимания.`,
        
        negative: `Ваша ментальная связь ослеплена оптимизмом. Вы игнорируете серьёзные проблемы в понимании, потому что «у нас всё прекрасно», и заставляете партнёра делать то же самое. 
        Доверие становится токсично позитивной: нельзя говорить о трудностях понимания, чтобы «не портить настроение». Вы создаёте атмосферу притворства в общении. 
        Умы страдают от этого отрицания реальности разного мышления. Ваша связь похожа на яркое солнце, которое слепит так, что не видно ямы непонимания под ногами. 
        Вы строите не свет, а ослепление, которое мешает видеть реальные проблемы в общении. Доверие становится обязанностью быть понятливыми, даже когда это невозможно.`,
        
        advice: `Создайте «расписание солнца и тени в общении»: выделите время для ясных разговоров и время для честного обсуждения трудностей понимания. 
        Практикуйте «игру в прятки с правдой о понимании»: один день полностью оптимистичный в общении, другой — реалистичный, потом найдите баланс. 
        Введите правило «тени под солнцем доверия»: на каждое оптимистичное утверждение о понимании находите один факт, который требует внимания. 
        Помните: даже солнце взаимопонимания имеет пятна — и это не делает его менее прекрасным.`
    },

    // 20. СУД
    "20": {
        positive: `Ваша ментальная связь получает второй шанс. Вы используете непонимание как возможность пересмотреть способы общения, простить старые обиды из-за неправильных трактовок и начать новый этап. 
        Создаёте ритуалы прощения и обновления в общении. Когнитивные трудности становятся точкой возрождения вашего доверия. 
        Вы — два человека, которые услышали призыв к пробуждению в понимании и ответили на него, очистив свои умы от груза прошлых недопониманий. 
        Умы обновляются, как после весеннего дождя. Доверие здесь — это не идеальная история без ошибок понимания, а история преодоления, которая делает ваше общение сильнее. 
        Вы строите отношения на фундаменте прощения и принятия различий в мышлении.`,
        
        negative: `Ваша ментальная связь погрязла в суде над прошлыми недопониманиями. Вы ищете виноватого в когнитивных трудностях и в проблемах общения, обвиняете друг друга. 
        Доверие превращается в бесконечный процесс взаимных обвинений в неясности. Вы создаёте атмосферу, где каждый чувствует себя преступником или судьёй в понимании. 
        Умы тяжелеют от чувства вины за неправильные трактовки. Ваша связь похожа на зал суда, который никогда не закрывается. 
        Вы строите не новое начало, а тюрьму для умов, где оба отбывают пожизненный срок за прошлые ошибки в понимании. Доверие становится наказанием.`,
        
        advice: `Проведите «ритуал последнего суда над непониманием»: напишите все претензии по поводу неправильных трактовок, зачитайте и сожгите. 
        Практикуйте «разговор под амнистией»: выделите день, когда запрещено вспоминать прошлые недопонимания. 
        Создайте «книгу возрождения понимания»: записывайте туда все положительные изменения в вашем общении после кризисов непонимания. 
        Помните: суд над пониманием должен завершиться оправданием или помилованием.`
    },

    // 21. МИР
    "21": {
        positive: `Ваша ментальная связь обретает целостность и завершённость. Вы интегрируете непонимание в вашу общую историю общения, не вытесняя его, а принимая как часть пути. 
        Создаёте гармоничную систему взаимопонимания, которая включает все аспекты — логический, интуитивный, духовный. Когнитивные трудности находят своё место и теряют разрушительную силу. 
        Вы — два человека, которые достигли мира с собой, друг другом и своими различиями в мышлении. Умы чувствуют себя целыми. 
        Доверие здесь — это не борьба за понимание, а состояние гармонии, которое само по себе исцеляет общение. Вы строите отношения как завершённую картину, где есть место всему, даже неясности и разногласиям.`,
        
        negative: `Ваша ментальная связь застывает в самодовольной гармонии. Вы делаете вид, что непонимание — это «часть прекрасного целого», и игнорируете его острые углы. 
        Доверие становится поверхностным — вы не хотите нарушать идиллию активными действиями по прояснению. Вы создаёте иллюзию, что всё и так прекрасно в понимании. 
        Умы засыпают в этой ложной гармонии. Ваша связь похожа на красивую, но мёртвую картину — всё на месте, но нет жизни в общении. 
        Вы строите не целостность, а гробницу для вашего взаимопонимания. Доверие становится ритуалом, который выполняют по привычке.`,
        
        advice: `Создайте «карту целостности с проблемными зонами в понимании»: отмечайте не только гармоничные аспекты общения, но и зоны напряжения. 
        Практикуйте «танец целого и части в общении»: во время разговора представляйте, что вы — единое целое, но иногда один становится «непонятливой частью», а другой — «ясной». 
        Введите правило «диссонанса в гармонии понимания»: раз в неделю нарочно нарушайте ваше спокойствие честным разговором о том, что не идеально в понимании. 
        Помните: истинный мир в общении включает в себя конфликты смыслов, которые разрешаются, а не отрицаются.`
    },

    // 22. ШУТ
    "22": {
        positive: `Ваша ментальная связь исцеляется через игру и лёгкость в понимании. Вы не воспринимаете непонимание трагично, а превращаете попытки понять друг друга в весёлое приключение. 
        Создаёте атмосферу, где можно быть большим ребёнком в общении: играть в слова, смеяться над неправильными трактовками, превращать объяснения в игру. 
        Когнитивные трудности не убивают вашу радость общения — вы находите поводы для смеха даже в самых сложных непониманиях. 
        Вы — два шута, которые проходят через испытания неясностью, не теряя чувства юмора. Умы остаются лёгкими, даже когда понимание тяжелеет. 
        Доверие здесь — это не тяжёлая обязанность понимать, а лёгкая игра, которая делает непонимание менее страшным.`,
        
        negative: `Ваша ментальная связь становится инфантильной и безответственной в понимании. Вы смеётесь над серьёзными недопониманиями, пока они не становятся опасными для отношений. 
        Доверие превращается в игру в телепатов, где никто не относится к пониманию серьёзно. 
        Вы создаёте атмосферу, где нельзя говорить о боли от непонимания, потому что «надо веселиться». 
        Умы не чувствуют серьёзного отношения к своим мыслям. Ваша связь похожа на цирк, где клоуны развлекаются, пока здание взаимопонимания горит. 
        Вы строите не игру, а побег от реальности разного мышления. Доверие становится способом не замечать проблемы в общении.`,
        
        advice: `Создайте «правило серьёзных пяти минут в общении»: каждый день выделяйте короткое время для обсуждения непониманий без шуток. 
        Практикуйте «ритуал переключения»: после серьёзного разговора о непонимании обязательно сделайте что-то весёлое вместе. 
        Ведите «дневник лёгкости в понимании»: записывайте, какие шутки и игры действительно помогают прояснить, а какие раздражают. 
        Помните: настоящая лёгкость в понимании умеет быть и глубокой, когда это нужно.`
    },

};