// public/js/database/compat/health.js

export const HEALTH_cAnahata = {
    // 1. МАГ
    "1": {
        positive: `Ваша сердечная связь становится инструментом осознанного исцеления. Вы направляете любовь и сострадание точно в цель, как хирурги — к больным местам друг друга. 
        Создаёте ритуалы эмоциональной поддержки: совместные медитации на исцеление сердца, аффирмации принятия, дыхательные практики синхронизации. 
        Ваша любовь не слепая — она видит слабости и работает с ними. Болезни сердца (как физические, так и эмоциональные) отступают перед вашей объединённой волей к гармонии. 
        Вы — маги эмоционального здоровья, превращающие боль в близость, а страх — в доверие.`,
        
        negative: `Ваша сердечная связь превращается в манипуляцию чувствами. Один использует болезнь как рычаг давления: «Если ты меня любишь, то выздоровеешь». 
        Любовь становится сделкой, сострадание — инструментом контроля. Вы играете в психологов, ставя друг другу диагнозы и назначая эмоциональные «процедуры». 
        Болезни усугубляются от напряжения — вы лечите не человека, а свой проект идеальных отношений. Сердце закрывается, а не исцеляется. 
        Ваша связь похожа на операцию без анестезии — больно, но почему-то продолжаете.`,
        
        advice: `Создайте «договор эмоциональной честности»: запретите использовать фразу «если ты меня любишь» в контексте здоровья. 
        Практикуйте «медитацию без цели»: просто сидите рядом, держась за руки, без ожиданий и анализа. 
        Ведите «журник сердечных импульсов»: записывайте, какие слова и действия действительно согревают сердце, а какие ранят. 
        Направляйте вашу магию на безусловную поддержку, а не на переделку друг друга.`
    },

    // 2. ЖРИЦА
    "2": {
        positive: `Ваша сердечная связь уходит корнями в глубины подсознания. Вы чувствуете эмоциональную боль друг друга без слов, как будто ваши сердца соединены тайными каналами. 
        Создаёте пространство молчаливой поддержки — иногда достаточно просто быть рядом, без советов и действий. Болезни становятся проводниками в тайные комнаты вашей близости. 
        Вы доверяете интуиции больше, чем внешним советам — и часто оказываетесь правы. Ваша любовь — это тихий разговор душ, который исцеляет глубже любых лекарств. 
        Вы — жрицы и жрецы храма ваших сердец, хранящие тайны друг друга и превращающие их в силу.`,
        
        negative: `Ваша сердечная связь тонет в невысказанном. Вы молча страдаете рядом, боясь нарушить священную тишину. Болезни прогрессируют в атмосфере тайн и намёков. 
        Любовь становится ритуалом молчания — вы боитесь говорить о боли, чтобы «не осквернить» вашу связь. Сердца отдаляются, хотя физически рядом. 
        Вы создаёте культ страдания, где болезнь — это нечто постыдное, что нужно скрывать даже от самого близкого. 
        Ваша связь похожа на два айсберга — на поверхности холод и тишина, а под водой — невысказанная боль.`,
        
        advice: `Установите «правило одного шёпота»: если слишком страшно говорить вслух, шепчите на ухо самое главное. 
        Практикуйте «письма от сердца»: пишите друг другу о своих чувствах, связанных с болезнью, и обменивайтесь, не читая при всех. 
        Создайте «шкатулку сердечных тайн» — храните там записки о самых страшных опасениях, раз в месяц доставайте и сжигайте одну. 
        Научитесь расшифровывать молчание, не превращая его в стену.`
    },

    // 3. ИМПЕРАТРИЦА
    "3": {
        positive: `Ваша сердечная связь цветёт как сад заботы и принятия. Вы превращаете болезнь в возможность проявить нежность в самых простых вещах: приготовить любимое блюдо, поправить подушку, просто погладить по голове. 
        Создаёте атмосферу эмоционального уюта, где можно быть слабым без стыда. Болезни становятся почвой, на которой растёт ваша взаимная забота. 
        Вы — садовники ваших сердец, поливающие их вниманием и теплом. Любовь здесь — не громкие слова, а ежедневные маленькие действия, которые говорят: «Я с тобой». 
        Сердца расцветают даже в болезни, потому что чувствуют себя в безопасности.`,
        
        negative: `Ваша сердечная связь становится удушающей опекой. Один превращает заботу в контроль: «Я лучше знаю, что тебе нужно». Любовь становится обязанностью. 
        Болезнь используется как способ привязать к себе, лишить самостоятельности. Вы создаёте отношения матери и ребёнка, где взрослый человек чувствует себя беспомощным. 
        Сердца задыхаются от избытка «заботы» — хочется сбежать, но некуда. Ваша связь похожа на теплицу, где цветы вянут от недостатка свободы. 
        Вы выращиваете не любовь, а зависимость.`,
        
        advice: `Создайте «меню заботы»: пусть больной сам выбирает из списка, какая помощь нужна сегодня. 
        Практикуйте «день равноправия»: даже если один болен, другой тоже имеет право на слабость и заботу. 
        Введите правило «спроси прежде чем сделать»: прежде чем проявить заботу, спрашивайте: «Тебе это сейчас нужно?». 
        Помните: истинная забота даёт свободу, а не отнимает её.`
    },

    // 4. ИМПЕРАТОР
    "4": {
        positive: `Ваша сердечная связь строится на надёжности и ответственности. Вы создаёте структуру поддержки: чёткий план ухода, распределение обязанностей, финансовую безопасность на время болезни. 
        Любовь проявляется как сила и защита — вы становитесь крепостью друг для друга. Болезни встречают организованное сопротивление, без паники и суеты. 
        Вы — правители вашего общего эмоционального пространства, устанавливающие границы и правила, которые защищают сердца. 
        Сердца чувствуют себя в безопасности, потому что знают: партнёр не подведёт. Любовь здесь — это не сантименты, а верность долгу заботы.`,
        
        negative: `Ваша сердечная связь превращается в диктатуру. Один берёт на себя роль командира, другой становится подчинённым. Любовь подменяется дисциплиной. 
        Болезнь используется как оправдание для тотального контроля. Вы создаёте иерархию, где у больного нет права голоса. 
        Сердца замирают от страха нарушить правила. Ваша связь похожа на армию, где чувства считаются слабостью. 
        Вы строите не крепость, а тюрьму для сердец. Любовь умирает под гнётом обязанностей.`,
        
        advice: `Создайте «конституцию заботы»: пропишите права и обязанности каждого, включая право на отказ от помощи. 
        Практикуйте «совет двух императоров»: все решения о лечении принимаются единогласно. 
        Введите «день анархии»: раз в месяц отменяйте все правила и просто будьте людьми, которые любят друг друга. 
        Помните: даже император иногда должен слушать своё сердце.`
    },

    // 5. ИЕРОФАНТ
    "5": {
        positive: `Ваша сердечная связь освящена общими духовными ценностями. Вы находите в болезни высший смысл — возможность для роста души, испытание вашей любви. 
        Молитесь вместе, медитируете, ищете кармические причины недугов. Любовь становится служением — вы видите в партнёре не просто человека, а божественное существо. 
        Болезни воспринимаются как уроки, которые нужно пройти с достоинством. Вы — духовные наставники друг для друга, помогающие найти свет в темноте. 
        Сердца соединяются на уровне души, и это даёт силы переносить физические страдания.`,
        
        negative: `Ваша сердечная связь становится догматичной. Один начинает поучать другого, ища «греховные» причины болезни. Любовь подменяется морализаторством. 
        Болезнь рассматривается как наказание за неправильные мысли или поступки. Вы создаёте культ страдания, где больной должен «искупить вину». 
        Сердца сжимаются от чувства вины. Ваша связь похожа на инквизицию, где любовь conditional — только если ты «достоин». 
        Вы строите не храм, а судилище для сердец. Духовность становится оружием эмоционального насилия.`,
        
        advice: `Создайте «синтез духовности и реальности»: духовные практики должны сопровождаться реальной медицинской помощью. 
        Практикуйте «ритуал безоценочного принятия»: говорите друг другу: «Ты имеешь право болеть, это не твоя вина». 
        Введите «день светской любви»: раз в неделю запрещайте все духовные разговоры и просто проявляйте человеческую нежность. 
        Помните: истинная духовность принимает, а не осуждает.`
    },

    // 6. ВЛЮБЛЕННЫЕ
    "6": {
        positive: `Ваша сердечная связь — это гармония и взаимный выбор. Вы выбираете любить друг друга каждый день, даже в болезни, даже в слабости. 
        Создаёте баланс между заботой и свободой — не душите, но и не бросаете. Болезни становятся точкой ещё большего сближения. 
        Вы — два сердца, бьющиеся в унисон, и этот ритм исцеляет. Любовь безусловна — вы хотите друг друга не только здоровыми, но и больными, потому что любите целиком. 
        Сердца раскрываются навстречу, потому что знают: их примут любыми. Вы строите отношения как вечный выбор в пользу друг друга.`,
        
        negative: `Ваша сердечная связь парализована вечным выбором. Вы не можете решить, как относиться к болезни партнёра, и застреваете в нерешительности. 
        Любовь становится испытанием, которое вы не проходите, потому что боитесь сделать неправильный выбор. Вы создаёте идеализированную картину, где болезнь — это помеха. 
        Сердца замирают в страхе разрушить идиллию. Ваша связь похожа на два человека на перепутье, которые так и не могут выбрать дорогу. 
        Вы строите не гармонию, а перманентные сомнения. Любовь становится проблемой, а не решением.`,
        
        advice: `Установите «правило простого выбора»: каждый день выбирайте одну маленькую форму проявления любви (поцелуй, комплимент, помощь). 
        Практикуйте «голосование сердца»: закройте глаза, положите руку на сердце партнёра и спросите себя: «Что ему сейчас нужно?». 
        Создайте «карту безопасной любви»: определите, какие проявления чувств уместны даже при обострении. 
        Помните: иногда выбор — это не между «правильно» и «неправильно», а между «сейчас» и «никогда».`
    },

    // 7. КОЛЕСНИЦА
    "7": {
        positive: `Ваша сердечная связь — это движущая сила, которая помогает преодолеть болезнь. Вы заряжаете друг друга энергией и оптимизмом, не позволяете унывать. 
        Создаёте динамику поддержки: вместе ищете врачей, изучаете методы лечения, ставите цели выздоровления. Болезни воспринимаются как препятствия, которые вы преодолеваете вместе. 
        Вы — команда, мчащаяся на колеснице любви к здоровью. Сердца бьются в такт общему движению. Любовь здесь — это не пассивное чувство, а активное действие. 
        Вы строите отношения как совместный проект, где болезнь — всего лишь очередной вызов.`,
        
        negative: `Ваша сердечная связь превращается в гонку. Вы требуете от партнёра немедленного выздоровления, не даёте времени на восстановление. 
        Любовь становится соревнованием: кто больше страдает, кто больше помогает. Вы создаёте атмосферу постоянного напряжения, где нельзя быть слабым. 
        Сердца устают от этой вечной гонки. Ваша связь похожа на две лошади, запряжённые в одну колесницу и рвущиеся в разные стороны. 
        Вы строите не команду, а конкурентов. Любовь становится ещё одним стресс-фактором.`,
        
        advice: `Создайте «контрольные точки отдыха»: в вашем плане лечения обязательно включайте дни полного покоя. 
        Практикуйте «совместное торможение»: когда один чувствует перегруз, другой поддерживает решение замедлиться. 
        Ведите «дневник достижений»: отмечайте не только медицинские успехи, но и моменты душевной близости. 
        Помните: иногда для победы нужно остановиться и просто быть вместе.`
    },

    // 8. СИЛА
    "8": {
        positive: `Ваша сердечная связь укрощает страх и боль. Вы не боитесь проявлять уязвимость, плакать вместе, злиться на болезнь. 
        Создаёте пространство, где можно выпустить наружу любые эмоции без осуждения. Болезни становятся учителями, показывающими, как любить по-настоящему. 
        Вы — укротители своих демонов, и ваша любовь — это безопасное поле для битвы с внутренними страхами. Сердца укрепляются, проходя через испытания вместе. 
        Любовь здесь — это не отсутствие конфликтов, а умение проходить через них, становясь ближе.`,
        
        negative: `Ваша сердечная связь превращается в силовую борьбу. Вы сражаетесь друг с другом за власть, используя болезнь как оружие. 
        Любовь становится полем битвы, где каждый пытается доказать свою правоту. Вы создаёте динамику мучителя и жертвы. 
        Сердца покрываются шрамами от взаимных обвинений. Ваша связь похожа на двух гладиаторов, которые режут друг друга, чтобы доказать свою силу. 
        Вы строите не безопасное пространство, а арену для выяснения отношений. Любовь становится пыткой.`,
        
        advice: `Создайте «договор о перемирии»: во время болезни все конфликты замораживаются. 
        Практикуйте «объятие силы»: обнимайте друг друга так крепко, как можете, пока не почувствуете, как напряжение уходит. 
        Введите правило «безопасного слова»: слово, которое сразу прекращает любой спор. 
        Помните: истинная сила — в умении быть слабым вместе.`
    },

    // 9. ОТШЕЛЬНИК
    "9": {
        positive: `Ваша сердечная связь уважает потребность в уединении. Вы понимаете, что иногда для исцеления нужно побыть наедине с собой, и не навязываетесь. 
        Создаёте пространство тихой поддержки — можно быть рядом, не тесня друг друга. Болезни становятся временем для внутренней работы, и вы уважаете этот процесс. 
        Вы — два отшельника, которые нашли друг в друге тихую гавань. Сердца отдыхают в этой тишине. Любовь здесь — это не постоянные разговоры, а глубинное понимание. 
        Вы строите отношения как два отдельных, но связанных мира.`,
        
        negative: `Ваша сердечная связь застывает в изоляции. Вы разбегаетесь по своим углам и перестаёте общаться. Болезнь становится оправданием для эмоциональной дистанции. 
        Любовь становится одинокой — каждый страдает в своём коконе. Вы создаёте два параллельных мира, которые почти не пересекаются. 
        Сердца замерзают от недостатка тепла. Ваша связь похожа на две одинокие планеты, вращающиеся каждая в своей орбите. 
        Вы строите не гавань, ледяную пустыню, где каждый умирает от холода в одиночку.`,
        
        advice: `Установите «ритуал соединения после уединения»: если один ушёл в себя, он обязуется вернуться через оговоренное время. 
        Практикуйте «параллельное присутствие»: находитесь в одной комнате, каждый занимается своим, но чувствуете поддержку просто от присутствия другого. 
        Создайте «систему сигналов»: определите знак, который означает «мне нужно побыть одному» и «я готов к контакту». 
        Помните: даже отшельник иногда нуждается в прикосновении.`
    },

    // 10. КОЛЕСО ФОРТУНЫ
    "10": {
        positive: `Ваша сердечная связь принимает взлёты и падения здоровья как естественный цикл. Вы не паникуете при обострениях и не расслабляетесь в ремиссиях, а адаптируетесь к изменениям. 
        Создаёте ритм поддержки, соответствующий фазам болезни. Болезни воспринимаются как временные неудачи в большой игре под названием жизнь. 
        Вы — игроки, которые делают ставки на любовь и выигрывают, даже когда проигрывают здоровье. Сердца учатся быть гибкими. 
        Любовь здесь — это не постоянное счастье, а умение держаться вместе в любую погоду.`,
        
        negative: `Ваша сердечная связь становится заложницей удачи. Вы любите друг друга только в хорошие периоды, а в болезни отдаляетесь. 
        Любовь зависит от обстоятельств — сегодня есть, завтра нет. Вы создаёте отношения, которые рушатся при первом серьёзном испытании. 
        Сердца не чувствуют надёжности. Ваша связь похожа на рулетку — никогда не знаешь, что выпадет завтра. 
        Вы строите не команду, двух одиночек, которые вместе только пока везёт. Любовь становится лотереей.`,
        
        advice: `Создайте «карту циклов»: отмечайте периоды, чтобы предсказывать сложные фазы и готовиться к ним эмоционально. 
        Практикуйте «ритуал постоянства»: каждый день, независимо от состояния, делайте одно маленькое проявление любви. 
        Введите «день безусловной любви»: раз в неделю любите друг друга специально, даже если всё плохо. 
        Помните: колесо фортуны вращают не только боги, но и ваши руки.`
    },

    // 11. СПРАВЕДЛИВОСТЬ
    "11": {
        positive: `Ваша сердечная связь стремится к балансу и справедливости. Вы взвешиваете эмоциональные потребности каждого и находите золотую середину. 
        Создаёте систему поддержки, где никто не остаётся в эмоциональном минусе. Болезни воспринимаются как задача, которую нужно решить совместно и объективно. 
        Вы — судьи ваших чувств, которые стараются быть беспристрастными. Сердца чувствуют, что их слышат и учитывают. 
        Любовь здесь — это не хаос страстей, а разумное партнёрство, основанное на взаимном уважении.`,
        
        negative: `Ваша сердечная связь превращается в суд. Вы подсчитываете, кто кому сколько должен в эмоциональном плане, требуете компенсаций. 
        Любовь становится сделкой: «Я тебе помог, теперь ты мне обязан». Вы создаёте атмосферу взаимных претензий. 
        Сердца страдают от чувства несправедливости. Ваша связь похожа на зал суда, где нет адвокатов, только прокуроры. 
        Вы строите не партнёрство, а бухгалтерию чувств. Любовь становится обязательством, а не даром.`,
        
        advice: `Создайте «договор о взаимной амнистии»: заранее договоритесь, что во время болезни не будете вести счёт. 
        Практикуйте «безусловную поддержку»: иногда помогайте просто потому, что хотите, без ожидания ответного действия. 
        Введите «день благодарности»: раз в неделю благодарите друг друга за всё, что сделали, без оценок «достаточно/недостаточно». 
        Помните: в любви, как и в здоровье, справедливость иногда должна уступать место милосердию.`
    },

    // 12. ПОВЕШЕННЫЙ
    "12": {
        positive: `Ваша сердечная связь находит новые глубины в ограничениях болезни. Вы используете вынужденную паузу, чтобы увидеть друг друга с новой стороны. 
        Создаёте пространство, где можно просто быть, без необходимости что-то делать или доказывать. Болезни становteachers, которые учат любить по-новому. 
        Вы — два повешенных, которые, вися вниз головой, видят мир перевёрнутым и находят в этом свою прелесть. Сердца открываются в беспомощности. 
        Любовь здесь — это не действие, а состояние, которое можно просто переживать вместе.`,
        
        negative: `Ваша сердечная связь застывает в жертвенности. Один полностью растворяется в болезни, другой — в роли мученика. 
        Любовь становится культом страдания. Вы создаёте отношения, где болезнь — центральная тема, а всё остальное — фон. 
        Сердца привыкают к этой роли и боятся выздоровления. Ваша связь похожа на два трупа, висящие на одном дереве. 
        Вы строите не новую перспективу, а могилу для ваших отношений. Любовь становится способом легализовать страдание.`,
        
        advice: `Установите «временные рамки для паузы»: период пассивного принятия не должен длиться больше определённого срока. 
        Практикуйте «смену перспективы»: лягте на пол в неудобной позе и смотрите на комнату по-новому, обсуждая, что видите. 
        Создайте «карту озарений»: записывайте insights, которые приходят в состоянии «подвешенности». 
        Помните: повешенный в итоге снимается с перекладины — готовьтесь к этому моменту вместе.`
    },

    // 13. СМЕРТЬ
    "13": {
        positive: `Ваша сердечная связь способна пережить смерть старых паттернов. Вы используете болезнь как точку радикального обновления отношений. 
        Отпускаете старые обиды, меняете привычные сценарии взаимодействия. Болезни становятся ритуалом перехода к новой фазе любви. 
        Вы — два феникса, которые сгорают в огне болезни, чтобы возродиться с обновлёнными сердцами. Любовь очищается от всего наносного. 
        Сердца умирают для старого и рождаются для нового. Вы строите отношения на пепелище прошлого, но это делает их прочнее.`,
        
        negative: `Ваша сердечная связь становится фаталистичной. Вы видите в болезни конец всему и впадаете в отчаяние. 
        Любовь превращается в предсмертную агонию. Вы создаёте атмосферу безысходности, где любой намёк на будущее кажется кощунством. 
        Сердца умирают раньше тела. Ваша связь похожа на похоронную процессию, которую вы проводите при живом партнёре. 
        Вы строите не новое, а могилу для вашей любви. Любовь становится репетицией смерти.`,
        
        advice: `Создайте «ритуал прощания со старым»: символически похороните те паттерны отношений, которые больше не служат. 
        Практикуйте «медитацию на жизнь после смерти»: представляйте, как будете любить друг друга после выздоровления. 
        Введите «день жизни»: раз в неделю запрещайте говорить о смерти и болезни, занимайтесь только тем, что напоминает о жизни. 
        Помните: смерть старого — необходимое условие для рождения нового.`
    },

    // 14. УМЕРЕННОСТЬ
    "14": {
        positive: `Ваша сердечная связь находит золотую середину между крайностями. Вы не впадаете в гиперопеку, но и не отдаляетесь, находите тот уровень близости, который исцеляет. 
        Создаёте гармоничную смесь разных подходов к поддержке. Болезни воспринимаются как дисбаланс, который можно исправить мягкой корректировкой отношений. 
        Вы — алхимики вашей любви, смешивающие противоположности в нужных пропорциях. Сердца чувствуют себя в равновесии. 
        Любовь здесь — это не страсть и не холод, а тёплая, устойчивая связь, которая даёт опору в трудные времена.`,
        
        negative: `Ваша сердечная связь становится вялой и компромиссной. Вы не можете определиться, как поддерживать друг друга, и останавливаетесь на чём-то среднем, что не удовлетворяет никого. 
        Любовь разбавляется страхом сделать что-то не так. Вы создаёте атмосферу «ни рыба ни мясо», где есть поддержка, но без души. 
        Сердца тонут в этой неопределённости. Ваша связь похожа на тёплую воду — не лечит и не калечит, просто есть. 
        Вы строите не гармонию, а болото, где всё медленно тонет. Любовь становится обязанностью, которую выполняют по минимуму.`,
        
        advice: `Создайте «шкалу умеренности»: от 0 (полное отстранение) до 10 (слияние) и стремитесь к 5-7. 
        Практикуйте «день крайностей»: один день будьте максимально близки, другой — дайте друг другу полную свободу, потом найдите середину. 
        Введите правило «обоюдного удовлетворения»: ищите такие формы поддержки, которые комфортны обоим. 
        Помните: умеренность — это не середина между «хочу» и «не хочу», а гармония между «могу» и «нужно».`
    },

    // 15. ДЬЯВОЛ
    "15": {
        positive: `Ваша сердечная связь принимает тёмные стороны болезни. Вы не отрицаете страх, гнев, отчаяние, а используете их энергию для укрепления связи. 
        Создаёте пространство, где можно говорить о самых запретных чувствах: «Я злюсь, что ты заболел», «Мне страшно тебя потерять». 
        Болезни становteachers, которые показывают вам теневые стороны вашей любви. Вы — два демона, которые укротили свою тьму и сделали её частью связи. 
        Сердца становятся целостными, принимая и свет, и тень. Любовь здесь — это не только радость, но и способность выдерживать вместе самые трудные чувства.`,
        
        negative: `Ваша сердечная связь попадает в плен к тёмным сторонам. Вы начинаете наслаждаться драмой, превращая болезнь в театр страданий. 
        Любовь становится игрой в жертву и тирана. Вы создаёте созависимые отношения, где болезнь — клей, который держит вас вместе. 
        Сердца привыкают к этой токсичной динамике. Ваша связь похожа на ад, который вы построили вместе и теперь не можете из него выйти. 
        Вы строите не целостность, а адскую машину взаимного уничтожения. Любовь становится болезнью.`,
        
        advice: `Создайте «договор с тенью»: определите, какие тёмные чувства можно выражать, а какие лучше оставить при себе. 
        Практикуйте «ритуал освобождения»: символически снимите с себя роли «жертва» и «тиран». 
        Введите «час света»: каждый день выделяйте время для разговоров о чём-то светлом и радостном. 
        Помните: даже дьявол когда-то был ангелом — найдите в своей тени искру света.`
    },

    // 16. БАШНЯ
    "16": {
        positive: `Ваша сердечная связь способна выдержать крушение иллюзий. Когда болезнь разрушает ваши представления о идеальных отношениях, вы не разбегаетесь, а находите в этом возможность для роста. 
        Создаёте новую, более честную и прочную связь на руинах старых ожиданий. Болезни становятся молниями, которые освещают истинную суть ваших чувств. 
        Вы — два строителя, которые после землетрясения начинают строить новый дом, более устойчивый к бурям. Сердца очищаются от всего наносного. 
        Любовь здесь — это не красивая картинка, а реальность, которую вы принимаете и продолжаете любить, даже когда она не идеальна.`,
        
        negative: `Ваша сердечная связь рушится при первом серьёзном испытании. Вы обвиняете друг друга в болезни, впадаете в панику, разбегаетесь по углам. 
        Любовь оказывается иллюзией, которая не выдерживает давления реальности. Вы создаёте атмосферу катастрофы, где любой конфликт кажется концом света. 
        Сердца ломаются от взаимных обвинений. Ваша связь похожа на карточный домик, который рухнул от первого дуновения ветра. 
        Вы строите не новый дом, а руины, в которых каждый хоронит свои надежды в одиночку. Любовь становится воспоминанием о чём-то, что могло бы быть.`,
        
        advice: `Создайте «план действий в кризисе»: заранее обсудите, как будете поддерживать друг друга в трудные времена. 
        Практикуйте «медитацию на руинах»: сядьте спина к спине и представьте, что всё рухнуло, а у вас осталась только эта точка соприкосновения. 
        Введите правило «одного дня без катастрофы»: раз в неделю запрещайте драматизировать и рассматривайте болезнь как временную трудность. 
        Помните: после разрушения Башни всегда открывается новый вид — ищите его вместе.`
    },

    // 17. ЗВЕЗДА
    "17": {
        positive: `Ваша сердечная связь освещается надеждой и верой. Даже в самой тяжёлой болезни вы находите в себе силы верить в лучшее и поддерживать эту веру в партнёре. 
        Создаёте ритуалы, которые напоминают о свете в конце туннеля: мечтаете вместе о будущем, смотрите на звёзды, говорите о том, что будет после выздоровления. 
        Болезни становятся тёмным небом, на котором особенно ярко горят звёзды вашей любви. Вы — два звёздных путешественника, которые даже в ночи болезни не теряют курс. 
        Сердца согреваются этой надеждой. Любовь здесь — это не отрицание реальности, а умение видеть свет даже в самой глубокой тьме.`,
        
        negative: `Ваша сердечная связь витает в облаках иллюзий. Вы отрицаете серьёзность болезни, прикрываясь красивыми фразами о любви и свете. 
        Любовь становится побегом от реальности. Вы создаёте мир фантазий, где нет места боли и страданиям. 
        Сердца отрываются от земли и парят в выдуманном мире. Ваша связь похожа на красивую сказку, под которой скрывается запущенная болезнь. 
        Вы строите не путь к звёздам, а воздушный замок, который рухнет при первом столкновении с реальностью. Любовь становится наркотиком, который помогает не видеть правды.`,
        
        advice: `Создайте «алтарь надежды и реальности»: на одной стороне разместите символы ваших мечтаний, на другой — медицинские факты. 
        Практикуйте «звёздный час»: час в день предавайтесь мечтам, остальное время действуйте реалистично. 
        Введите правило «одной горькой правды в день»: каждый день говорите одну неприятную правду о здоровье, а потом находите один луч надежды. 
        Помните: звёзды светят, но чтобы добраться до них, нужно идти по земле.`
    },

    // 18. ЛУНА
    "18": {
        positive: `Ваша сердечная связь основана на интуиции и принятии неопределённости. Вы доверяете внутренним ощущениям больше, чем внешним диагнозам. 
        Создаёте пространство, где можно делиться самыми иррациональными страхами и снами, связанными с болезнью. Болезни становятся проводниками в подсознание. 
        Вы — два медиума, которые слышат голоса своих сердец и следуют им. Сердца общаются на языке символов и ощущений. 
        Любовь здесь — это не логика, а поток чувств, который иногда противоречит разуму, но ведёт к исцелению. Вы строите отношения как плавание по морю эмоций с доверием к внутреннему компасу.`,
        
        negative: `Ваша сердечная связь тонет в страхах и иллюзиях. Вы видите опасности там, где их нет, и подозреваете друг друга в скрытых мотивах. 
        Любовь становится лабиринтом подозрений и догадок. Вы создаёте атмосферу постоянной неопределённости, где никогда не знаете, чего ждать друг от друга. 
        Сердца путаются в этом тумане. Ваша связь похожа на блуждание в потёмках, где каждый шаг может быть ошибкой. 
        Вы строите не внутренний компас, а лабиринт, из которого не можете найти выход. Любовь становится источником тревоги, а не успокоения.`,
        
        advice: `Создайте «дневник страхов и фактов»: слева записывайте все страхи, связанные с болезнью и отношениями, справа — объективные данные. 
        Практикуйте «ритуал заземления»: вместе опускайте босые ноги на пол, дышите и называйте три реальных ощущения в теле. 
        Введите «световой режим»: в тёмное время суток не принимайте важных решений о отношениях и здоровье. 
        Помните: луна светит отражённым светом — ищите источник ваших страхов.`
    },

    // 19. СОЛНЦЕ
    "19": {
        positive: `Ваша сердечная связь сияет радостью и принятием. Вы встречаете болезнь с оптимизмом и верой в лучшее, и эта энергия передаётся партнёру. 
        Создаёте атмосферу тепла и света, где даже в болезни можно находить моменты счастья. Болезни воспринимаются как временные облака, которые не могут затмить ваше солнце. 
        Вы — два солнца, которые, даже когда одно затмевается, другое светит за двоих. Сердца согреваются этой взаимной поддержкой. 
        Любовь здесь — это не отрицание трудностей, а умение видеть хорошее даже в самой сложной ситуации. Вы строите отношения как путь к свету, даже если временно находитесь в тени.`,
        
        negative: `Ваша сердечная связь ослеплена оптимизмом. Вы игнорируете серьёзные проблемы, потому что «у нас всё прекрасно», и заставляете партнёра делать то же самое. 
        Любовь становится токсично позитивной: нельзя говорить о боли и страхе, чтобы «не портить настроение». Вы создаёте атмосферу притворства. 
        Сердца страдают от этого отрицания реальности. Ваша связь похожа на яркое солнце, которое слепит так, что не видно ямы под ногами. 
        Вы строите не свет, а ослепление, которое мешает видеть реальные проблемы. Любовь становится обязанностью быть счастливыми, даже когда это невозможно.`,
        
        advice: `Создайте «расписание солнца и тени»: выделите время для радостных занятий и время для честного разговора о трудностях. 
        Практикуйте «игру в прятки с правдой»: один день полностью оптимистичный, другой — реалистичный, потом найдите баланс. 
        Введите правило «тени под солнцем»: на каждое оптимистичное утверждение находите один факт, который требует внимания. 
        Помните: даже солнце имеет пятна — и это не делает его менее прекрасным.`
    },

    // 20. СУД
    "20": {
        positive: `Ваша сердечная связь получает второй шанс. Вы используете болезнь как возможность пересмотреть отношения, простить старые обиды и начать новый этап. 
        Создаёте ритуалы прощения и обновления. Болезни становятся точкой возрождения вашей любви. 
        Вы — два человека, которые услышали призыв к пробуждению и ответили на него, очистив свои сердца от груза прошлого. 
        Сердца обновляются, как после весеннего дождя. Любовь здесь — это не идеальная история без ошибок, а история преодоления, которая делает вас сильнее. 
        Вы строите отношения на фундаменте прощения и принятия.`,
        
        negative: `Ваша сердечная связь погрязла в суде над прошлым. Вы ищете виноватого в болезни и в проблемах отношений, обвиняете друг друга. 
        Любовь превращается в бесконечный процесс взаимных обвинений. Вы создаёте атмосферу, где каждый чувствует себя преступником или судьёй. 
        Сердца тяжелеют от чувства вины. Ваша связь похожа на зал суда, который никогда не закрывается. 
        Вы строите не новое начало, а тюрьму для сердец, где оба отбывают пожизненный срок за прошлые ошибки. Любовь становится наказанием.`,
        
        advice: `Проведите «ритуал последнего суда»: напишите все претензии друг к другу, зачитайте и сожгите. 
        Практикуйте «разговор под амнистией»: выделите день, когда запрещено вспоминать прошлые обиды. 
        Создайте «книгу возрождения»: записывайте туда все положительные изменения в ваших отношениях после болезни. 
        Помните: суд должен завершиться оправданием или помилованием.`
    },

    // 21. МИР
    "21": {
        positive: `Ваша сердечная связь обретает целостность и завершённость. Вы интегрируете болезнь в вашу общую историю, не вытесняя её, а принимая как часть пути. 
        Создаёте гармоничную систему поддержки, которая включает все аспекты — физический, эмоциональный, духовный. Болезни находят своё место и теряют разрушительную силу. 
        Вы — два человека, которые достигли мира с собой, друг другом и своей судьбой. Сердца чувствуют себя целыми. 
        Любовь здесь — это не борьба, а состояние гармонии, которое само по себе исцеляет. Вы строите отношения как завершённую картину, где есть место всему, даже боли и слабости.`,
        
        negative: `Ваша сердечная связь застывает в самодовольной гармонии. Вы делаете вид, что болезнь — это «часть прекрасного целого», и игнорируете её острые углы. 
        Любовь становится поверхностной — вы не хотите нарушать идиллию активными действиями. Вы создаёте иллюзию, что всё и так прекрасно. 
        Сердца засыпают в этой ложной гармонии. Ваша связь похожа на красивую, но мёртвую картину — всё на месте, но нет жизни. 
        Вы строите не целостность, а гробницу для ваших чувств. Любовь становится ритуалом, который выполняют по привычке.`,
        
        advice: `Создайте «карту целостности с проблемными зонами»: отмечайте не только гармоничные аспекты, но и зоны напряжения. 
        Практикуйте «танец целого и части»: во время близости представляйте, что вы — единое целое, но иногда один становится «больной частью», а другой — «здоровой». 
        Введите правило «диссонанса в гармонии»: раз в неделю нарочно нарушайте ваше спокойствие честным разговором о том, что не идеально. 
        Помните: истинный мир включает в себя конфликты, которые разрешаются, а не отрицаются.`
    },

    // 22. ШУТ
    "22": {
        positive: `Ваша сердечная связь исцеляется через игру и лёгкость. Вы не воспринимаете болезнь трагично, а превращаете уход за партнёром в весёлое приключение. 
        Создаёте атмосферу, где можно быть большим ребёнком: дурачиться, смеяться над симптомами, превращать процедуры в игру. 
        Болезни не убивают вашу радость — вы находите поводы для смеха даже в самых сложных ситуациях. 
        Вы — два шута, которые проходят через испытания, не теряя чувства юмора. Сердца остаются лёгкими, даже когда тело тяжелеет. 
        Любовь здесь — это не тяжёлая обязанность, а лёгкая игра, которая делает болезнь менее страшной.`,
        
        negative: `Ваша сердечная связь становится инфантильной и безответственной. Вы смеётесь над серьёзными симптомами, пока они не становятся опасными. 
        Любовь превращается в игру в доктора и пациента, где никто не относится к болезни серьёзно. 
        Вы создаёте атмосферу, где нельзя говорить о боли и страхе, потому что «надо веселиться». 
        Сердца не чувствуют серьёзного отношения к себе. Ваша связь похожа на цирк, где клоуны развлекаются, пока здание горит. 
        Вы строите не игру, а побег от реальности. Любовь становится способом не замечать проблемы.`,
        
        advice: `Создайте «правило серьёзных пяти минут»: каждый день выделяйте короткое время для обсуждения симптомов без шуток. 
        Практикуйте «ритуал переключения»: после серьёзного разговора обязательно сделайте что-то весёлое вместе. 
        Ведите «дневник лёгкости»: записывайте, какие шутки и игры действительно поднимают настроение, а какие раздражают. 
        Помните: настоящая лёгкость умеет быть и глубокой, когда это нужно.`
    },

};