// public/js/database/compat/health/compat-Sahasrara.js

export const HEALTH_cSahasrara = {


    // 1. МАГ
    "1": {
        positive: `Вы — алхимики духовного здоровья, превращающие болезнь в ресурс роста. Каждый симптом — материал для совместного творчества. 
        Создаёте уникальные ритуалы исцеления: синхронизируете дыхание, программируете подсознание аффирмациями, используете тело как инструмент трансформации. 
        Ваша связь — лаборатория, где ставят эксперименты над сознанием и физиологией. Учитесь управлять биохимией силой намерения. 
        Плацебо-эффект достигает 90%, потому что верите не в таблетку, а в союз. Болезни отступают как вызов для творческого прорыва.`,
        
        negative: `Ваше манипулятивное начало превращает целительство в опасную игру. Один назначает «кармические диагнозы», навязывает сложные практики. 
        Доводите партнёра до срыва, пытаясь «исцелить прошлые жизни». Каждый симптом — повод для духовного шантажа: «Болит спина — несёшь непосильную карму». 
        Игнорируете реальные медицинские причины, заменяя их эзотерическими трактовками. Тело — поле битвы амбиций двух магов, доказывающих своё превосходство. 
        Лечение становится способом контроля, а не помощи.`,
        
        advice: `Создайте «Кодекс духовного целителя»: любой симптом сначала проверяется у врача, потом анализируется духовно. 
        Разделите роли: один отвечает за медицинские решения, другой — за энергетическую поддержку. Меняйтесь ролями каждый месяц. 
        Проводите ритуал «Очищения от манипуляций»: говорите о симптомах, партнёр может предложить лишь одну практику и только после фразы «я готов это попробовать». 
        Запретите фразу «я же хочу как лучше».`
    },
    
    // 2. ЖРИЦА
    "2": {
        positive: `Ваше духовное здоровье строится на интуитивном контакте с глубинными процессами организма. Чувствуете нарушения у партнёра до их проявления, 
        будто тела соединены тайными каналами. Сны становятся источником диагностики — подсказывают, на какой орган обратить внимание. 
        Практикуете совместное молчание как форму исцеления: в тишине синхронизируете биоритмы, запуская регенерацию. 
        Связь даёт доступ к коллективному бессознательному здоровья, где хранятся архетипические паттерны исцеления. 
        Умеете «считывать» истинные причины болезней в подавленных эмоциях или родовых сценариях.`,
        
        negative: `Ваша таинственность становится опасной скрытностью. Один годами скрывает диагноз, обосновывая «кармической тайной». 
        Погружаетесь в мистификацию здоровья: создаёте сложные системы символических соответствий, упуская реальные сроки лечения. 
        Молчание становится разрушительным — накапливаются невысказанные страхи и подозрения. Впадаете в духовный нарциссизм: 
        считаете болезни «особой миссией», отказываясь от помощи, обрекая партнёра на роль немого свидетеля страдания. 
        Тайна превращается в стену, а болезнь — в единственный способ получить внимание.`,
        
        advice: `Установите правило «Тайна до вторника»: если почувствовали тревожное, обязаны сообщить до вторника, но можете выбрать форму (слова, рисунок, жест). 
        Создайте «священный журнал симптомов» — красивую тетрадь, куда записываете всё о здоровье без оценок. Раз в неделю перечитывайте записи при свечах — 
        это превратит скрытое в явное. Найдите «переводчика» — третье лицо (врача или психолога), который поможет расшифровать интуитивные прозрения в конкретные действия. 
        Раз в квартал проводите «ночь откровений» с обязательным последующим действием.`
    },

    // 3. ИМПЕРАТРИЦА
    "3": {
        positive: `Ваше духовное здоровье — это плодородная почва, где болезнь превращается в возможность творческого роста. 
        Вы выращиваете здоровье как сад: совместные ритуалы с растениями, работа с землёй, создание телесных мандал. 
        Тела воспринимаются как священные сосуды, требующие заботы и украшения. Беременность (физическая или творческая) протекает гармонично, 
        потому что вы создаёте пространство принятия. Исцеление через красоту: окружение себя искусством, музыкой, природой. 
        Ваша связь даёт телу чувство безопасности, необходимое для самовосстановления.`,
        
        negative: `Забота превращается в гиперопеку, подавляющую волю тела. Один назначает другому диеты, травы, процедуры, игнорируя личные потребности. 
        Болезнь становится способом получить внимание, и вы попадаете в замкнутый круг: чем больше лечите, тем больше болеют. 
        Увязаете в бытовых ритуалах «для здоровья», которые не работают, но становятся обязательной повинностью. 
        Творческая энергия направляется не на исцеление, а на создание иллюзии благополучия. Тело «цветёт» только под вашим контролем, теряя автономию.`,
        
        advice: `Создайте «Сад свободного роста»: посадите растение, за которым ухаживаете без строгих правил. Раз в неделю проводите «день непослушания»: 
        ешьте что хочется, спите когда хотите, без оздоровительных программ. Разрешите болезни быть без немедленного «лечения». 
        Практикуйте «заботу без контроля»: один день в месяц каждый заботится о себе сам, партнёр лишь наблюдает без комментариев. 
        Превратите гиперопеку в искусство: создавайте вместе красивые вещи, не связанные со здоровьем.`
    },

    // 4. ИМПЕРАТОР
    "4": {
        positive: `Ваше духовное здоровье строится на дисциплине и структуре. Создаёте чёткие ритуалы, протоколы, системы профилактики. 
        Тело воспринимается как храм, требующий порядка и уважения. Совместные практики дают ощущение контроля над здоровьем: утренние зарядки, 
        медитации по расписанию, системный подход к питанию. Болезнь становится вызовом, который встречаете с холодной головой, 
        разрабатывая стратегию исцеления. Ваша связь даёт опору и стабильность, необходимые для долгосрочного здоровья.`,
        
        negative: `Контроль превращается в тиранию. Один устанавливает жёсткие правила, игнорируя потребности тела партнёра. 
        Болезнь воспринимается как слабость или неповиновение. Вы лечите не человека, а «случай», применяя стандартные протоколы без индивидуального подхода. 
        Духовные практики становятся обязаловкой, вызывающей сопротивление. Тело мстит психосоматикой на давление. 
        Здоровье — поле битвы за власть, где один командует, а другой саботирует лечение.`,
        
        advice: `Создайте «Конституцию здоровья» с правами и обязанностями каждого. Включите право на «бунт» — один день в месяц можно нарушать все правила. 
        Назначьте «министра здравоохранения» на ротационной основе. Раз в квартал проводите «ревизию правил» — отменяйте устаревшие. 
        Введите систему баллов: за соблюдение режима — баллы, которые можно обменять на отступления от него. 
        Лечите не болезнь, а человека: перед каждым решением спрашивайте «Что ты сейчас чувствуешь в теле?».`
    },

    // 5. ИЕРОФАНТ
    "5": {
        positive: `Ваше духовное здоровье обретает смысл в рамках традиции или общей философии. Вы находите исцеление в ритуалах, 
        молитвах, совместном служении высшей идее. Болезнь воспринимается как урок или испытание, которое проходите вместе, укрепляя веру. 
        Обращаетесь к проверенным временем практикам, избегая крайностей. Тело становится инструментом духовного роста, 
        а его ограничения — возможностью для смирения и мудрости. Ваша связь даёт ощущение принадлежности к чему-то большему, 
        что помогает переносить физические страдания.`,
        
        negative: `Догматизм убивает гибкость в лечении. Следуете устаревшим или неподходящим практикам из упрямства. 
        Один навязывает другому свои духовные взгляды под видом заботы о здоровье. Болезнь становится наказанием за «грехи» или отклонения от правил. 
        Отказываетесь от современных методов лечения в пользу «проверенных предками». Тело страдает от фанатизма, 
        а духовные практики превращаются в самоцензуру, где нельзя жаловаться или сомневаться.`,
        
        advice: `Создайте «Совет мудрецов»: пригласите трёх специалистов (врача, психолога, духовного наставника) для консультации по здоровью. 
        Разработайте личный ритуал, сочетающий традиционные и современные подходы. Практикуйте «диалог с симптомом»: 
        спрашивайте, чему он учит, но не забывайте лечить. Раз в год проходите «чистку догм» — отказывайтесь от одной традиционной практики, 
        заменяя её чем-то новым. Помните: тело — не храм для фанатиков, а живой организм.`
    },

    // 6. ВЛЮБЛЕННЫЕ
    "6": {
        positive: `Ваше духовное здоровье строится на гармонии выбора и принятия. Болезнь становится точкой соединения, 
        где учитесь слушать тело друг друга без осуждения. Совместные практики основаны на взаимном удовольствии: парная йога, 
        танцы, медитации взглядом. Тела входят в резонанс, синхронизируя биоритмы. Исцеление происходит через любовь и принятие, 
        когда один становится «зеркалом» для другого, помогая увидеть дисгармонию. Ваш союз — лаборатория безусловной любви к телу во всех его проявлениях.`,
        
        negative: `Вечные сомнения парализуют лечение. Не можете выбрать между традиционной и альтернативной медициной, 
        упуская время. Идеализируете здоровье, отказываясь видеть реальные проблемы. Один жертвует своим здоровьем ради другого, 
        создавая токсичный дисбаланс. Болезнь становится испытанием для любви, которое не выдерживает давления. 
        Тела страдают от нерешительности, а духовные практики превращаются в способ избежать трудного выбора.`,
        
        advice: `Установите правило «Выбор за 24 часа»: при возникновении симптомов у вас есть сутки на принятие решения о лечении. 
        Создайте «колесо баланса»: разделите сферы здоровья (физическое, эмоциональное, духовное) и еженедельно оценивайте, 
        что требует внимания. Практикуйте «медитацию выбора»: садитесь спиной к спине и молча принимаете решение, потом сравниваете. 
        Если выборы разные — ищете компромисс. Разрешите болезни быть, не делая её испытанием любви.`
    },

    // 7. КОЛЕСНИЦА
    "7": {
        positive: `Ваше духовное здоровье — это движение к цели, где болезнь становится препятствием, которое преодолеваете вместе. 
        Совместные практики заряжены энергией: динамические медитации, паломничества к местам силы, спортивные достижения как духовный путь. 
        Тела учатся преодолевать ограничения, превращая слабость в силу. Исцеление через волю: ставите цели по здоровью и достигаете их, 
        поддерживая друг друга. Ваша связь даёт импульс для преодоления любых недугов, превращая лечение в приключение.`,
        
        negative: `Гонка за результатами разрушает тело. Не замечаете усталости, пока не случится срыв. Лечение превращается в соревнование: 
        кто быстрее выздоровеет, кто выдержит более жёсткую практику. Один тянет другого за собой, игнорируя сигналы тела. 
        Болезнь воспринимается как поражение, что приводит к скрыванию симптомов. Духовные практики становятся ещё одним способом доказать свою силу, 
        а не исцелиться. Тело ломается под давлением амбиций.`,
        
        advice: `Установите «контрольные точки»: каждую неделю проверяйте не только прогресс, но и уровень усталости. 
        Создайте ритуал «остановки»: раз в месяц проводите день полного бездействия. Практикуйте «медленные практики»: 
        цигун, тайцзи, где важнее процесс, чем результат. Введите правило: при возникновении симптомов сначала отдых 48 часов, 
        потом действия. Смените лозунг «преодолеть» на «принять и трансформировать».`
    },

    // 8. СИЛА
    "8": {
        positive: `Ваше духовное здоровье строится на укрощении внутренних демонов. Болезнь воспринимается как проявление подавленной энергии, 
        которую учитесь направлять вместе. Совместные практики работы с гневом, страхом, желанием: ритуальные танцы, работа с голосом, 
        телесные терапии. Тела становятся проводниками трансформированной энергии. Исцеление через принятие своей тени и поддержку партнёра в этом. 
        Ваша связь даёт смелость встретиться с самыми тёмными аспектами здоровья, не убегая от них.`,
        
        negative: `Сила превращается в насилие над телом. Один заставляет другого «преодолевать» боль, игнорируя ограничения. 
        Болезнь воспринимается как слабость, которую нужно подавить силой воли. Духовные практики становятся способом выпустить агрессию, 
        а не исцелиться. Тело бунтует ещё более серьёзными заболеваниями. Вы играете в «кто сильнее», где проигрывают оба. 
        Исцеление подменяется победой над симптомами, которые возвращаются с удвоенной силой.`,
        
        advice: `Создайте «священное пространство» для выражения любых эмоций без осуждения. Практикуйте «объятие с сопротивлением»: 
        один сопротивляется, другой обнимает, потом меняются. Это учит силе без насилия. Введите правило «стоп-слово» для любых практик. 
        Раз в неделю проводите «ночь страха»: делитесь самыми тёмными мыслями о здоровье, не пытаясь их исправить. 
        Помните: истинная сила — в уязвимости, которую вы можете позволить друг другу.`
    },

    // 9. ОТШЕЛЬНИК
    "9": {
        positive: `Ваше духовное здоровье требует уединения и глубины. Болезнь становится поводом для внутреннего поиска, 
        который уважаете в друг друге. Даёте пространство для одиноких практик, понимая, что истинное исцеление приходит изнутри. 
        Совместные молчаливые ретриты, практики внутреннего света, изучение древних текстов. Тела отдыхают от необходимости «быть вместе», 
        восстанавливаясь в одиночестве. Ваша связь ценит тишину больше слов, позволяя каждому найти свой путь к здоровью.`,
        
        negative: `Уединение превращается в изоляцию. Один уходит в болезнь, другой не решается нарушить его покой. 
        Лечение откладывается «пока не будет готов». Духовные практики становятся побегом от совместного решения проблем. 
        Тела страдают в одиночку, а связь атрофируется от недостатка контакта. Болезнь становится оправданием для эмоциональной дистанции. 
        Вы лечитесь порознь, даже когда проблема общая, теряя силу союза.`,
        
        advice: `Установите «ритм одиночества и встречи»: например, 3 дня личных практик, 1 день совместного обсуждения. 
        Создайте «журнал внутреннего путешественника» — записывайте insights о здоровье, которыми делитесь раз в неделю. 
        Практикуйте «молчание вместе»: сидите в одной комнате, занимаясь каждый своим, но в присутствии друг друга. 
        Определите «красные флаги»: симптомы, при которых уединение прерывается обязательной консультацией. 
        Помните: отшельник иногда возвращается в деревню за помощью.`
    },

    // 10. КОЛЕСО ФОРТУНЫ
    "10": {
        positive: `Ваше духовное здоровье принимает цикличность бытия. Болезни воспринимаются как фазы естественного цикла, 
        которые нужно пройти с мудростью. Учитесь читать знаки судьбы в симптомах, видя в них не случайность, а закономерность. 
        Совместные практики работы с кармой, ритуалы принятия перемен. Тела учатся адаптироваться к изменениям, поддерживая друг друга. 
        Ваша связь даёт устойчивость в любых поворотах судьбы, превращая кризисы здоровья в точки роста.`,
        
        negative: `Фатализм парализует волю к лечению. Считаете болезни «кармическим наказанием», которое нужно просто пережить. 
        Отказываетесь от активных действий, надеясь, что «колесо само повернётся». Один винит другого в «плохой карме», 
        усугубляя чувство вины. Духовные практики становятся способом снять с себя ответственность. Тела страдают от пассивности, 
        а болезнь закрепляется как «судьба». Вы плывёте по течению, пока не наткнётесь на водопад.`,
        
        advice: `Создайте «карту циклов»: отмечайте периоды обострения и ремиссии, ищите закономерности. 
        Практикуйте «ритуал поворота колеса»: в моменты кризиса вместе принимаете решение об изменении подхода к лечению. 
        Введите правило «активное принятие»: принимаете ситуацию, но ищете минимум 3 варианта действия. 
        Раз в год проводите «аудит кармы здоровья»: анализируете, какие установки мешают, и меняете их. 
        Помните: колесо можно толкнуть в нужном направлении.`
    },

    // 11. СПРАВЕДЛИВОСТЬ
    "11": {
        positive: `Ваше духовное здоровье строится на балансе и справедливости. Ищете причинно-следственные связи в болезнях, 
        подходя к лечению системно. Совместные практики восстановления гармонии: медитации равновесия, ритуалы очищения кармы, 
        работа с законом причин и следствий. Тела учатся компенсировать дисбалансы друг друга. Исцеление через понимание: 
        анализируете, какие действия привели к болезни, и корректируете их вместе. Ваша связь даёт объективность, необходимую для истинного исцеления.`,
        
        negative: `Справедливость превращается в суд. Ищете виноватого в болезни: ты неправильно питался, ты не следил за здоровьем. 
        Лечение становится наказанием за «преступления против тела». Один назначает другому «справедливые» практики, игнорируя индивидуальность. 
        Духовные практики превращаются в способ доказать свою правоту. Тело страдает от чувства вины, которое блокирует исцеление. 
        Вы лечите не человека, а «нарушение баланса», забывая о сострадании.`,
        
        advice: `Создайте «Суд совести»: раз в месяц каждый рассказывает о своих «преступлениях против здоровья» без осуждения партнёра. 
        Практикуйте «медитацию беспристрастного наблюдателя»: вместе наблюдаете за симптомами, не давая оценок. 
        Введите правило «амнистии»: раз в квартал прощаете друг другу все прошлые ошибки в отношении здоровья. 
        Балансируйте справедливость милосердием: иногда тело нуждается в прощении больше, чем в правде.`
    },

    // 12. ПОВЕШЕННЫЙ
    "12": {
        positive: `Ваше духовное здоровье требует остановки и смены перспективы. Болезнь становится вынужденной паузой, 
        которую используете для переосмысления ценностей. Совместные практики сдачи контроля: медитации неделания, 
        доверие течению, принятие беспомощности. Тела учатся исцеляться через капитуляцию. Ваша связь даёт опору в периоды бездействия, 
        позволяя каждому зависнуть в своём процессе, не теряя контакта. Исцеление приходит не через борьбу, а через принятие ограничений.`,
        
        negative: `Пассивность становится бегством от ответственности. Один «зависает» в болезни, другой поддерживает как мученика. 
        Лечение откладывается «пока не придёт озарение». Духовные практики превращаются в оправдание бездействия. 
        Тело привыкает к состоянию жертвы, теряя волю к исцелению. Вы застреваете в страдании, наслаждаясь духовной значимостью боли. 
        Болезнь становится идентичностью, от которой не хотите отказываться.`,
        
        advice: `Установите «лимит подвешенного состояния»: например, 2 недели пассивного принятия, потом обязательное действие. 
        Практикуйте «ритуал переворота»: ложитесь на пол, смотрите на комнату с другого ракурса, обсуждаете, что видите по-новому. 
        Создайте «карту озарений» — записывайте insights, которые приходят в периоды бездействия, и раз в неделю выбираете одно для реализации. 
        Помните: повешенный в итоге снимается с перекладины — готовьтесь к этому моменту вместе.`
    },

    // 13. СМЕРТЬ
    "13": {
        positive: `Ваше духовное здоровье требует радикальных трансформаций. Болезнь становится сигналом к смерти старого образа жизни, 
        который отпускаете вместе. Совместные практики завершения: ритуалы прощания с вредными привычками, символические похороны болезней, 
        медитации перерождения. Тела учатся умирать и возрождаться в безопасном пространстве вашей связи. Исцеление через разрушение: 
        позволяете болезни сделать свою работу — очистить организм от того, что больше не служит. Ваш союз даёт смелость встретить конец, 
        чтобы начать новое.`,
        
        negative: `Разрушение становится самоцелью. Рушите здоровье ради «очищения», впадая в экстремальные практики. 
        Один заставляет другого отказываться от необходимого (например, лекарств) под видом «смерти эго». Болезнь идеализируется 
        как путь к просветлению. Тело истощается от постоянных «трансформаций». Вы убиваете в себе не только болезнь, 
        но и жизненную силу. Духовные практики превращаются в медленное самоубийство с благословения партнёра.`,
        
        advice: `Создайте «ритуал контролируемого разрушения»: например, сожгите список того, от чего хотите избавиться, 
        но оставьте один пункт для реальных изменений. Практикуйте «медитацию феникса»: представляете, что сгораете, 
        но договариваетесь, что возродитесь вместе. Введите правило «сохранения ядра»: определяете, что в вашем здоровье неприкосновенно. 
        Раз в год проходите «символическую смерть» под наблюдением специалиста (терапевта, психолога). Помните: смерть должна служить жизни.`
    },

    // 14. УМЕРЕННОСТЬ
    "14": {
        positive: `Ваше духовное здоровье — это искусство смешения противоположностей в гармоничный эликсир. Болезнь воспринимается как дисбаланс, 
        который исправляете, находя золотую середину. Совместные практики синтеза: медитации слияния энергий, создание индивидуальных ритуалов 
        из разных традиций, поиск третьего пути в лечении. Тела учатся адаптироваться, получая от каждого из вас то, что необходимо. 
        Исцеление через умеренность: избегаете крайностей, находите баланс между активностью и покоем, традицией и инновациями. 
        Ваша связь — сосуд, где противоположности становятся целым.`,
        
        negative: `Умеренность становится компромиссом, устраивающим обоих, но не решающим проблему. Ищете середину между разными подходами к лечению, 
        в результате не следуете ни одному. Болезнь затягивается из-за половинчатых мер. Один разбавляет усилия другого, не давая достичь критической массы для исцеления. 
        Духовные практики превращаются в бесконечное смешение без глубины. Тело получает противоречивые сигналы и не знает, как реагировать.`,
        
        advice: `Создайте «лабораторию синтеза»: экспериментируйте с сочетанием практик, но ведите дневник эффективности. 
        Практикуйте «медитацию золотой середины»: садитесь друг напротив друга, представляете крайние позиции, потом находите точку равновесия. 
        Введите правило «целостного цикла»: неделю применяете один подход, неделю — другой, потом неделю их синтез. 
        Раз в месяц проводите «аудит баланса»: проверяете, не стало ли умеренность безразличием.`
    },

    // 15. ДЬЯВОЛ
    "15": {
        positive: `Ваше духовное здоровье принимает тень во всей её полноте. Болезнь воспринимаете как подавленную энергию, 
        которую высвобождаете через осознанные практики работы с запретным. Совместные ритуалы интеграции теневых аспектов: 
        работа с сексуальной энергией, выражение гнева в безопасном пространстве, принятие «недуховных» желаний тела. 
        Тела исцеляются, когда перестают скрывать свои тёмные стороны. Ваша связь даёт смелость встретиться с демонами здоровья, 
        не боясь осуждения. Исцеление через принятие всей полноты бытия, включая то, что общество считает болезнью.`,
        
        negative: `Тень захватывает власть. Заигрываете с опасными практиками, оправдывая их «духовным ростом». Один вовлекает другого в деструктивные привычки 
        под видом «освобождения от ограничений». Болезнь романтизируется как проявление тёмной природы. Духовные практики превращаются в оправдание пороков. 
        Тело разрушается от вседозволенности, а вы называете это «исцелением через падение». Вы становитесь рабами своих демонов, прикованными цепями созависимости.`,
        
        advice: `Создайте «священный договор с тенью»: определяете, какие аспекты интегрируете, а какие остаются под запретом. 
        Практикуйте «ритуал освобождения в клетке»: выделяете безопасное пространство и время для выражения теневых энергий. 
        Назначьте «хранителя границ» — третье лицо, которое будет сигнализировать, когда вы заходите слишком далеко. 
        Раз в месяц проводите «детокс от дьявола» — день строгой дисциплины как противовес. Помните: дьявол — тоже часть божественного.`
    },

    // 16. БАШНЯ
    "16": {
        positive: `Ваше духовное здоровье требует разрушения иллюзий для прорыва. Болезнь становится молнией, 
        разрушающей ложные представления о теле и здоровье. Вместе переживаете крах старых систем и строите новые на руинах. 
        Совместные практики принятия внезапных изменений: медитации в хаосе, ритуалы очищения огнём, обучение resilience. 
        Тела освобождаются от накопленных блоков через кризис. Ваша связь даёт опору, когда рушится всё, что казалось незыблемым. 
        Исцеление через правду, какой бы разрушительной она ни была.`,
        
        negative: `Разрушение становится привычкой. Рушите здоровье друг друга постоянными сменами курса, экспериментами, резкими переменами. 
        Один провоцирует кризисы у другого под видом «духовного роста». Болезни воспринимаются исключительно как наказание за иллюзии, 
        что усиливает чувство вины. Духовные практики превращаете в перманентную революцию, не давая телу адаптироваться. 
        Вы живёте в состоянии вечной Башни, где каждый день — новое разрушение. Тело не выдерживает постоянных потрясений.`,
        
        advice: `Создайте «фундамент непоколебимого»: определите 3 аспекта здоровья, которые не будете менять ни при каких условиях. 
        Практикуйте «ритуал контролируемого разрушения»: раз в квартал позволяете рухнуть одной привычке или убеждению, но готовите замену заранее. 
        Введите правило «периода восстановления»: после каждого кризиса даёте себе месяц стабильности. 
        Стройте не на пепелище, а на расчищенном фундаменте — находите время для этого.`
    },

    // 17. ЗВЕЗДА
    "17": {
        positive: `Ваше духовное здоровье наполняется надеждой и верой в лучшее. Болезнь воспринимаете как временную тьму, 
        сквозь которую пробиваетесь к своему внутреннему свету. Совместные практики подключения к источнику: медитации на звёздное небо, 
        работа с визуализацией исцеления, создание общей мечты о здоровье. Тела откликаются на вашу веру, запуская процессы самовосстановления. 
        Ваша связь становится проводником надежды, когда силы на исходе. Исцеление через вдохновение и веру в чудо, которое создаёте вместе.`,
        
        negative: `Надежда становится побегом от реальности. Верите в исцеление так сильно, что игнорируете симптомы и откладываете лечение. 
        Один кормит другого иллюзиями вместо реальной помощи. Болезнь затягивается, потому что «мы визуализируем здоровье, и этого достаточно». 
        Духовные практики превращаются в способ не замечать проблему. Вы парите в своих фантазиях, пока тело страдает на земле. 
        Звезда становится недосягаемым идеалом, до которого «недостойны» болеть.`,
        
        advice: `Создайте «карту реальности и мечты»: разделите лист на две части — что есть и что визуализируете. 
        Практикуйте «заземлённую визуализацию»: представляете исцеление, но тут же назначаете конкретное действие на сегодня. 
        Введите правило «звёздного часа»: час в день можете предаваться надежде, остальное время — практические действия. 
        Найдите «звезду-проводника» — человека, который уже прошёл подобный путь исцеления, и учитесь у него реализму. 
        Помните: звёзды светят, но не греют — нужны земные средства.`
    },

    // 18. ЛУНА
    "18": {
        positive: `Ваше духовное здоровье плывёт по течению бессознательного. Болезнь воспринимаете как сообщение из глубин подсознания, 
        которое расшифровываете вместе. Совместные практики работы со снами, интуицией, подсознательными страхами: ведение дневников сновидений, 
        медитации в сумерках, ритуалы доверия интуиции. Тела говорят вам через симптомы на языке символов. Ваша связь даёт безопасность для погружения 
        в тёмные воды психики. Исцеление происходит, когда признаёте и интегрируете то, что скрывалось в тени.`,
        
        negative: `Иллюзии захватывают вас. Видите болезни там, где их нет, поддаваясь взаимной ипохондрии. Один заражает другого своими страхами, 
        создавая порочный круг тревоги. Путаете духовные озарения с психопатологией. Тело реагирует на ваши фантомные страхи реальными симптомами. 
        Духовные практики превращаются в блуждание в тумане, где вы лишь накручиваете друг друга. Вы тонете в океане подсознания, не находя берега.`,
        
        advice: `Создайте «компас реальности»: список из 5 объективных показателей здоровья (анализы, вес, давление и т.д.), 
        на которые будете опираться при сомнениях. Практикуйте «ритуал различения»: записывайте интуитивные прозрения и проверяете их у врача в течение недели. 
        Введите «ночь страха» раз в месяц: выписываете все страхи о здоровье, а утром сжигаете список. 
        Найдите «маяк» — специалиста (психолога или опытного целителя), который поможет отличить интуицию от иллюзии.`
    },

    // 19. СОЛНЦЕ
    "19": {
        positive: `Ваше духовное здоровье сияет радостью и жизненной силой. Болезнь воспринимаете как временное облако, которое рассеиваете 
        светом своего союза. Совместные практики наполнения энергией: солнечные медитации, танцы, смехотерапия, благодарность телу. 
        Тела расцветают в атмосфере принятия и радости. Ваша связь становится источником жизненной силы, ускоряющим исцеление. 
        Вы верите в здоровье как естественное состояние, и эта вера становится самосбывающимся пророчеством. Исцеление через наслаждение жизнью и друг другом.`,
        
        negative: `Оптимизм становится отрицанием проблем. Игнорируете симптомы, потому что «у нас всё прекрасно». 
        Один заставляет другого «не раскисать» и «думать о хорошем», запрещая говорить о боли. Болезнь усугубляется, пока вы делаете вид, 
        что её нет. Духовные практики превращаются в способ избежать тёмных сторон здоровья. Вы ослеплены своим светом и не видите теней. 
        Тело кричит о помощи, но вы слишком громко поёте гимны солнцу.`,
        
        advice: `Создайте «ритм света и тени»: утром — практики радости, вечером — 15 минут на обсуждение любых неприятных симптомов без осуждения. 
        Практикуйте «благодарность болезни»: находите, чему она учит, не отрицая её существования. 
        Введите правило «честного солнца»: раз в неделю говорите друг другу одну неприятную правду о здоровье, но заканчивайте на трёх благодарностях телу. 
        Помните: солнце тоже имеет пятна — и это не умаляет его свет.`
    },

    // 20. СУД
    "20": {
        positive: `Ваше духовное здоровье получает второй шанс через глубокое переосмысление. Болезнь воспринимаете как призыв к пробуждению 
        и трансформации старых паттернов. Совместные практики возрождения: ритуалы прощения себя и друг друга, работа с родовыми сценариями здоровья, 
        медитации обновления. Тела откликаются на вашу готовность начать с чистого листа. Ваша связь даёт поддержку для того, чтобы услышать «призыв» 
        и ответить на него вместе. Исцеление через принятие ответственности за здоровье без чувства вины за прошлые ошибки.`,
        
        negative: `Чувство вины парализует исцеление. Поиск «кармических причин» болезни превращается в самобичевание. 
        Один обвиняет другого в «неправильном образе жизни в прошлых жизнях». Болезнь воспринимается как наказание, которое нужно просто отбыть. 
        Духовные практики становятся способом усилить чувство вины. Тело не может исцелиться, потому что вы не позволяете себе прощения. 
        Вы застреваете в суде над собой и друг другом, забывая о милосердии.`,
        
        advice: `Создайте «ритуал последнего суда»: напишите все обвинения в адрес друг друга по поводу здоровья, проведите символический суд, 
        вынесите приговор — и тут же подпишите амнистию. Практикуйте «медитацию невиновности»: представляете, что ваши тела чисты от любой кармы. 
        Введите правило «срока давности»: всё, что было больше года назад, не обсуждается как причина нынешних болезней. 
        Найдите «адвоката» — человека, который будет напоминать вам о праве на ошибку. Помните: суд должен завершиться оправданием.`
    },

    // 21. МИР
    "21": {
        positive: `Ваше духовное здоровье обретает целостность и завершённость. Болезнь воспринимаете как часть великого цикла, 
        которую интегрируете в общую картину бытия. Совместные практики единства: медитации на взаимосвязь всего сущего, 
        ритуалы благодарности за уроки болезни, создание общей философии здоровья. Тела становятся частью космического танца, 
        где здоровье и болезнь — лишь разные движения. Ваша связь даёт ощущение, что вы — часть чего-то большего, 
        и это помогает переносить любые испытания. Исцеление через принятие целостности, где болезнь не чужеродна, а часть пути к гармонии.`,
        
        negative: `Целостность становится застоем. Принимаете болезнь как «часть жизни» настолько, что перестаёте что-либо менять. 
        Один убеждает другого, что «так и должно быть», блокируя волю к исцелению. Болезнь становится удобной частью вашей идентичности как пары. 
        Духовные практики превращаются в способ законсервировать status quo. Вы наслаждаетесь философией целостности, пока тело разваливается. 
        Мир становится кладбищем ваших амбиций по здоровью.`,
        
        advice: `Создайте «карту целостности с динамикой»: отмечаете, что принимаете, а что хотите изменить, и балансируете эти аспекты. 
        Практикуйте «танец целостности»: двигаясь вместе, показываете через движение, что принимаете, а что трансформируете. 
        Введите правило «гармоничного развития»: раз в месяц вносите одно изменение в образ жизни, не нарушая общего баланса. 
        Помните: мир — это не статичная картина, а живой организм, который дышит и меняется. Ваше здоровье — часть этого дыхания.`
    },

    // 22. ШУТ
    "22": {
        positive: `Ваше духовное здоровье — это свободное падение в бездну возможностей без страха и догм. Вы позволяете друг другу самые еретические практики, видя в болезни лишь маску духа. 
        Спонтанные ритуалы, священный смех вместо молитв, экстатический танец как медитация — ваши тела становятся проводниками хаотичной божественной энергии. 
        Вы ломаете все блоки через игровое безумие, где симптомы теряют власть, а диагнозы растворяются в моменте присутствия. 
        Этот союз даёт редкую свободу: можно сойти с ума вместе, не боясь осуждения, и в этом безумии найти подлинное исцеление.`,
        
        negative: `Ваша духовная вседозволенность становится побегом от реальности тела. Игнорируя врачей, вы лечите рак мантрами, а депрессию — астральными путешествиями. 
        Один впадает в мистический психоз, другой поддерживает как «просветление». Тело становится полем битвы непризнанных демонов. 
        Практики превращаются в изощренное самоистязание: голодовки «для очищения», разрушительные ритуалы без заземления. 
        Вы теряете связь с физическим планом, и тело мстит необратимыми патологиями, пока вы парете в духовных иллюзиях.`,
        
        advice: `Установите «заземляющие» ритуалы. Каждую субботу — совместное приготовление простой еды. Раз в месяц — чекап у материалистичного врача. 
        Создайте «шкалу безумия»: при уровне 7+ разрешены любые эксперименты, ниже 4 — только сон, еда, прогулки. 
        Ведите дневник физических ощущений после каждой практики — это якорь в реальности. Разрешите себе 2 дня годового священного безумия, но с последующей полной диагностикой.`
    },
};