// public/js/database/compat/health/compat-Vishudha.js

export const HEALTH_cVishudha = {

    // 1. МАГ
    "1": {
        positive: `Вы — режиссёры речи о здоровье. Слово становится лекарством: правильно сформулированные аффирмации, 
        точные описания симптомов, исцеляющие диалоги. Вы создаёте совместные ритуалы вербальной магии: заговоры на здоровье, 
        мантры с голосом партнёра, поэзию как терапию. Ваши тела откликаются на ясность формулировок — вы не путаете «болит» и «ноет». 
        Вы умеете задавать друг другу вопросы, раскрывающие истинные причины болезней. Исцеление через называние вещей своими именами без страха.`,
        
        negative: `Вы манипулируете словами, чтобы скрыть правду о здоровье. Один называет рак «небольшим воспалением», 
        другой верит в эту ложь до последней стадии. Вы играете в игру «угадай диагноз по намёкам», вместо того чтобы говорить прямо. 
        Лечение превращается в битву риторики: кто убедительнее докажет свою правоту. Вы используете медицинские термины как оружие для запугивания. 
        Тело страдает от двусмысленности — оно не понимает, чего вы от него хотите. Ваши разговоры о здоровье полны умных слов и нулевого смысла.`,
        
        advice: `Создайте «словарь точности»: запишите 10 слов, которые точно описывают ваши ощущения в теле. Используйте только их при обсуждении здоровья. 
        Практикуйте «диалог без подтекста»: раз в неделю говорите о симптомах, запрещая любые метафоры и намёки. 
        Введите правило «прямого перевода»: если один говорит «что-то не так», другой обязан спросить «где именно и как болит?». 
        Назначьте «хранителя правды» — диктофон, который записывает ваши разговоры о здоровье для последующего анализа на честность.`
    },

    // 2. ЖРИЦА
    "2": {
        positive: `Ваше здоровье говорит шёпотом интуиции. Вы слышите не слова, а паузы между ними — то, что тело боится сказать вслух. 
        Вы понимаете друг друга без объяснений: один взгляд — и диагноз ясен. Совместные практики: медитации молчания, 
        чтение мыслей о здоровье, сны как диагностический инструмент. Вы доверяете внутреннему голосу больше, чем врачебным заключениям, 
        и часто оказываетесь правы. Ваша связь позволяет говорить о самых табуированных темах здоровья — тех, о которых стыдно сказать кому-либо ещё.`,
        
        negative: `Вы утопаете в недоговорённостях. Один молча страдает, другой молча догадывается — и оба ждут, кто первым заговорит. 
        Вы создаёте культ «тонких намёков», где прямое обращение за помощью считается грубостью. Болезнь становится семейной тайной, 
        которую шепчутся в соседней комнате. Вы слышите только то, что хотите услышать, игнорируя реальные крики тела. 
        Ваша коммуникация о здоровье — это игра в молчанку, где проигрывает тот, кто первым признает проблему. Тело сходит с ума от этого шепота.`,
        
        advice: `Установите «час исповеди»: раз в неделю в полной темноте говорите о симптомах, которые стыдно озвучить при свете. 
        Практикуйте «письма от тела»: каждый пишет письмо от имени своего тела партнёру, потом зачитывает вслух. 
        Создайте «шкаф скелетов» — коробку, куда складываете записки о самых страшных опасениях по здоровью, раз в месяц достаёте и сжигаете. 
        Найдите «переводчика» — психосоматолога, который поможет расшифровать ваше молчание.`
    },

    // 3. ИМПЕРАТРИЦА
    "3": {
        positive: `Ваше здоровье обретает голос через красоту и творчество. Вы говорите о симптомах языком искусства: рисуете боль, 
        танцуете диагноз, сочиняете поэмы о выздоровлении. Совместные практики: создание «книги здоровья» с иллюстрациями, 
        пение мантр в унисон, ведение эстетичного дневника симптомов. Вы превращаете болезнь в материал для творческого проекта. 
        Ваши разговоры о здоровье полны метафор плодородия и роста — даже рак вы называете «неконтролируемым цветением». Тело откликается на эту красоту.`,
        
        negative: `Вы говорите о здоровье только красивыми словами, приукрашивая реальность. Один называет истощение «эфирной лёгкостью», 
        другой — «божественной стройностью». Вы создаёте культ эстетики болезни: фотографируете исхудавшее тело как искусство. 
        Прямые разговоры о симптомах считаете «неэлегантными». Вы лечитесь не лекарствами, а «красивыми ритуалами», которые не работают. 
        Тело становится холстом для ваших иллюзий, пока болезнь пишет на нём свои уродливые картины.`,
        
        advice: `Создайте «галерею правды»: рисуйте симптомы такими, какие они есть — без прикрас, потом разглядывайте вместе. 
        Практикуйте «танец симптомов»: двигайтесь так, как чувствует ваше тело, не стараясь сделать это красиво. 
        Введите правило «уродливой правды»: раз в неделю описывайте болезнь самыми неприглядными словами. 
        Найдите баланс: один день говорите о здоровье как поэты, другой — как патологоанатомы.`
    },

    // 4. ИМПЕРАТОР
    "4": {
        positive: `Ваше здоровье подчиняется чёткой системе коммуникации. Вы создаёте протоколы обсуждения симптомов: 
        ежедневные отчёты, структурированные диалоги, иерархию жалоб. Совместные практики: составление медицинских карт друг друга, 
        проведение «совещаний по здоровью», использование точной терминологии. Вы говорите о болезнях как генералы о битвах — стратегически, 
        без эмоций. Тело получает ясные команды, и болезнь отступает под натиском вашей организованности. Ваши разговоры эффективны и результативны.`,
        
        negative: `Вы превращаете обсуждение здоровья в военный трибунал. Один допрашивает другого о симптомах, как следователь. 
        Жалобы считаются «докладами», которые должны быть оформлены по стандарту. Вы подавляете эмоциональную составляющую болезни, 
        называя её «слабостью». Тело взбунтуется — либо тихой забастовкой (хронические боли), либо открытым мятежом (острый приступ). 
        Вы лечите не человека, а «случай», общаясь через медицинские протоколы, а не через сопереживание. Ваши диалоги сухи и безжизненны.`,
        
        advice: `Создайте «конституцию здоровья» с правами на нечёткие формулировки. Практикуйте «ролевую игру»: один день говорите как врач и пациент, 
        другой — как два испуганных ребёнка. Введите правило «5 минут хаоса»: в конце каждого структурированного обсуждения позволяйте себе 
        поток сознания о симптомах. Назначьте «министра эмоций», который будет следить, чтобы факты не задушили чувства.`
    },

    // 5. ИЕРОФАНТ
    "5": {
        positive: `Ваше здоровье обретает смысл в рамках общей духовной традиции. Вы говорите о болезнях как о «уроках», 
        «кармических задачах», «испытаниях духа». Совместные практики: молитвы о здоровье, исповеди в симптомах, 
        изучение священных текстов о телесности. Вы находите утешение в ритуализированной речи — заученных молитвах, 
        благословениях, канонических описаниях болезней. Тело воспринимается как храм, а симптомы — как знаки высшей воли. 
        Ваши разговоры дают чувство осмысленности страдания.`,
        
        negative: `Вы тонете в догматических формулировках. Один называет болезнь «наказанием за грехи», другой верит и страдает ещё больше. 
        Вы запрещаете говорить о симптомах вне разрешённого духовного контекста. Лечение подменяется ритуалами: не таблетки, а молитвы; 
        не операция, а пост. Вы говорите на мёртвом языке религиозных клише, не слыша криков живого тела. Тело становится жертвой вашего фанатизма, 
        а болезнь — плахой для еретического желания выздороветь «недуховными» методами.`,
        
        advice: `Создайте «живой канон»: записывайте свои собственные молитвы о здоровье, а не используйте чужие. 
        Практикуйте «диалог трёх голосов»: говорите о симптоме как верующий, как скептик и как сам симптом — потом найдите общее. 
        Введите правило «земного перевода»: после каждой духовной беседы о здоровье пересказывайте её простыми словами «что будем делать». 
        Найдите «светского гуру» — врача, который уважает ваши взгляды, но не разделяет их фанатично.`
    },

    // 6. ВЛЮБЛЕННЫЕ
    "6": {
        positive: `Ваше здоровье обсуждается в режиме дуэта гармонии. Вы говорите о симптомах как о возможности для большего сближения. 
        Совместные практики: диалоги взглядами, завершение медицинских фраз друг за друга, созвучие в описании ощущений. 
        Вы умеете слушать не только слова, но и интонации, паузы, дыхание. Ваши разговоры о здоровье полны нежности и принятия — 
        даже самая неприглядная болезнь обсуждается с любовью. Тело раскрывается навстречу этому диалогу, ускоряя исцеление. 
        Вы выбираете здоровье каждый день, и ваш язык отражает этот выбор.`,
        
        negative: `Вы застряли в сладкозвучных иллюзиях. Один говорит «мы здоровы», потому что боится разрушить идиллию, другой молча соглашается. 
        Вы обсуждаете болезни только в романтическом ключе: «наша любовь сильнее любой хвори». Прямые разговоры о симптомах считаются «негармоничными». 
        Вы лечитесь комплиментами вместо лекарств. Тело страдает от этой сладкой лжи, но молчит, чтобы не расстроить партнёра. 
        Ваши диалоги похожи на дуэт двух соловьёв, поющих над пропастью болезней.`,
        
        advice: `Установите правило «горькой правды в мёде»: каждый день говорите одну неприятную правду о здоровье, заедая её тремя комплиментами телу. 
        Практикуйте «разговор рук»: обсуждайте симптомы, держась за руки — физический контакт поможет выдержать правду. 
        Создайте «ящик для страхов»: пишите друг другу письма о самых страшных опасениях, читайте их вместе при свечах. 
        Помните: истинная гармония включает в себя диссонанс.`
    },

    // 7. КОЛЕСНИЦА
    "7": {
        positive: `Ваше здоровье — это поле битвы, где вы союзники. Вы говорите о симптомах как о противниках, которых нужно победить вместе. 
        Совместные практики: боевые кличи перед походом к врачу, тактические совещания о лечении, речи перед «битвой» с болезнью. 
        Ваши разговоры заряжены энергией и волей к победе. Вы не жалуетесь, а констатируете факты и разрабатываете стратегию. 
        Тело откликается на этот командный дух, мобилизуя ресурсы. Вы говорите быстро, чётко, по делу — без нытья и расплывчатости.`,
        
        negative: `Вы превращаете обсуждение здоровья в гонку за последним словом. Один перебивает другого, доказывая свою осведомлённость. 
        Симптомы становятся поводом для соревнования: «у меня болит сильнее». Вы говорите о лечении как о гонке вооружений — 
        кто найдёт более дорогое лекарство, более известного врача. Тело истощается от этой вечной гонки. 
        Ваши диалоги напоминают переговоры двух генералов, которые забыли, за что воюют. Вы лечите не болезнь, а своё эго.`,
        
        advice: `Создайте «правило тишины после речи»: после того как один высказался о симптомах, второй молчит 30 секунд перед ответом. 
        Практикуйте «совместное дыхание» перед обсуждением здоровья — синхронизируйте дыхание, чтобы говорить в одном ритме. 
        Введите «день перемирия»: раз в неделю обсуждайте симптомы без соревновательности, как два учёных, изучающих феномен. 
        Назначьте «арбитра» — диктофон, который будет определять, кто больше перебивает.`
    },

    // 8. СИЛА
    "8": {
        positive: `Ваше здоровье говорит языком укрощённой страсти. Вы разрешаете себе говорить о симптомах с яростью, страхом, отчаянием — 
        без цензуры. Совместные практики: рычащая терапия, крик в подушку вдвоём, диалоги на повышенных тонах с последующим примирением. 
        Вы не боитесь испугать друг друга правдой о боли. Ваши разговоры освобождают подавленную энергию болезни. 
        Тело благодарно за эту честность — симптомы теряют власть, когда названы в полный голос. Вы говорите как укротители, которые знают, 
        как обращаться с хищником-болезнью.`,
        
        negative: `Ваши разговоры о здоровье превращаются в взаимные обвинения и скандалы. Они винит другого в своих болезнях: «ты меня довёл». 
        Вы кричите о симптомах, но не слышите друг друга. Диалог становится способом выпустить агрессию, а не решить проблему. 
        Тело зажимается от этого шума, болезнь уходит вглубь. Вы лечитесь не лекарствами, а «выяснением отношений», которое только усугубляет стресс. 
        Ваша коммуникация — это бой без правил, где ранят словами, а лечат молчанием.`,
        
        advice: `Установите «правило тихого часа»: обсуждайте здоровье только шёпотом. Практикуйте «ритуал рычания»: сначала 5 минут рычите друг на друга, 
        потом 10 минут говорите спокойно. Создайте «мешок для криков» — подушку, в которую можно кричать, пока партнёр говорит о симптомах. 
        Введите «эмоциональную разметку»: перед разговором определяйте, какая эмоция сейчас у каждого, и учитывайте это.`
    },

    // 9. ОТШЕЛЬНИК
    "9": {
        positive: `Ваше здоровье требует тишины для понимания. Вы говорите о симптомах мало, но метко — после долгого внутреннего обдумывания. 
        Совместные практики: молчаливое сидение с симптомами, переписка о здоровье вместо разговоров, медитации перед обсуждением лечения. 
        Вы цените не количество слов, а их глубину. Ваши диалоги похожи на обмен цитатами из внутренних откровений. 
        Тело чувствует это уважение к тишине и раскрывает тайны, которые никогда не сказало бы в шумной беседе. 
        Вы говорите тогда, когда слова действительно могут исцелить.`,
        
        negative: `Вы замираете в молчании перед лицом болезни. Один молча страдает, другой молча наблюдает — оба ждут, что проблема решится сама. 
        Обсуждение здоровья считается «суетой». Вы лечитесь молчаливым осуждением: «если бы ты правильно жил, не болел бы». 
        Тело кричит от одиночества в этой тишине. Вы проходите мимо симптомов, как отшельники мимо мирских соблазнов, пока болезнь не становится вашей единственной реальностью. 
        Ваша коммуникация — это пустыня, где умирают невысказанные просьбы о помощи.`,
        
        advice: `Создайте «колокол откровений»: звонок, который любой может позвонить, чтобы начать разговор о здоровье. 
        Практикуйте «письма из пещеры»: каждый пишет о симптомах в дневник, потом оставляет его открытым на特定ной странице для партнёра. 
        Введите правило «одного слова»: раз в день каждый говорит одно слово, описывающее состояние здоровья, без объяснений. 
        Найдите «проводника тишины» — психолога, который поможет вам говорить, не нарушая внутренней тишины.`
    },

    // 10. КОЛЕСО ФОРТУНЫ
    "10": {
        positive: `Ваше здоровье обсуждается в контексте циклов и перемен. Вы говорите о симптомах как о «полосах», «фазах», «поворотах судьбы». 
        Совместные практики: составление карт цикличности болезней, ритуалы приветствия новых симптомов как знаков, 
        диалоги о здоровье в контексте астрологических или кармических циклов. Вы не паникуете от обострений, зная, что за ними последует улучшение. 
        Ваши разговоры дают ощущение предсказуемости в непредсказуемом мире болезней. Тело учится доверять этим циклам.`,
        
        negative: `Вы говорите о здоровье только как о везении или невезении. «Повезло — не повезло» — ваш единственный диагноз. 
        Вы не берёте ответственность за лечение, списывая всё на судьбу. Обсуждение симптомов превращается в гадание: «к чему бы это?». 
        Тело становится игрушкой в руках слепой фортуны. Вы лечитесь не методами, а надеждой, что «колесо повернётся». 
        Ваши диалоги — это перечисление случайностей, где нет места закономерностям и действиям.`,
        
        advice: `Создайте «календарь циклов»: отмечайте периоды обострений и ремиссий, ищите закономерности в разговорах. 
        Практикуйте «диалог двух голосов»: один говорит как фаталист, другой — как сторонник ответственности, потом меняйтесь. 
        Введите правило «случайность не случайна»: каждый раз, списав симптом на судьбу, ищите хотя бы одну реальную причину. 
        Найдите «статистика» — врача или аналитика, который поможет увидеть закономерности в ваших историях болезни.`
    },

    // 11. СПРАВЕДЛИВОСТЬ
    "11": {
        positive: `Ваше здоровье обсуждается с позиций баланса и справедливости. Вы говорите о симптомах как о последствиях причин, 
        которые можно понять и исправить. Совместные практики: взвешивание аргументов за и против разных методов лечения, 
        диалоги-расследования причин болезни, составление «балансовых отчётов» здоровья. Ваши разговоры логичны, объективны, 
        направлены на поиск истины. Тело получает ясные сигналы о том, что за ним следят не эмоционально, а ответственно. 
        Вы лечите не симптом, а причину, потому что ваш диалог позволяет докопаться до сути.`,
        
        negative: `Вы превращаете обсуждение здоровья в судебный процесс. Один выступает обвинителем: «ты сам виноват, что заболел», 
        другой — адвокатом или подсудимым. Вы ищете не истину, а виноватого. Симптомы становятся уликами в деле о «преступлении против здоровья». 
        Тело страдает от этого суда, болезнь усугубляется чувством вины. Вы лечитесь не методами, а «вынесением приговоров» старому образу жизни. 
        Ваши диалоги — это перебранка двух юристов, забывших о клиенте (вашем теле).`,
        
        advice: `Создайте «суд присяжных из вас двоих»: рассматривайте симптом как явление, а не как чью-то вину. 
        Практикуйте «разговор весов»: на каждое обвинение находите оправдание, на каждое оправдание — обвинение, пока не сбалансируете. 
        Введите правило «амнистии»: раз в месяц прощайте друг другу все «преступления против здоровья». 
        Назначьте «судью» — блокнот, куда записываете все обвинения и оправдания, потом анализируете вместе.`
    },

    // 12. ПОВЕШЕННЫЙ
    "12": {
        positive: `Ваше здоровье требует разговоров с перевёрнутой точки зрения. Вы говорите о симптомах как о возможностях, 
        а не как о проблемах. Совместные практики: диалоги в неудобных позах, обсуждение здоровья лёжа на полу, 
        формулирование симптомов задом наперёд. Вы учитесь видеть болезнь как учителя, а боль — как сообщение. 
        Ваши разговоры полны парадоксов, которые открывают новые пути исцеления. Тело благодарно за этот нестандартный подход — 
        оно получает шанс быть услышанным необычным образом. Вы говорите так, как никто не говорил о ваших болезнях, и это исцеляет.`,
        
        negative: `Ваши разговоры о здоровье застыли в мученической позе. Вы говорите о симптомах как о кресте, который нужно нести. 
        Обсуждение превращается в соревнование в страдании: «я больше выношу». Вы лечитесь не действиями, а «принятием своей участи». 
        Тело замирает в этой позе жертвы, болезнь становится идентичностью. Ваши диалоги — это взаимные жалобы, зацикленные на одном и том же. 
        Вы говорите, но не слышите, потому что все слова уже сказаны, а боль осталась.`,
        
        advice: `Практикуйте «диалог вниз головой»: лягте на кровать так, чтобы голова свешивалась, и говорите о симптомах. 
        Создайте «словарь перевёртышей»: называйте боль «радостью», болезнь — «здоровьем», и наблюдайте, что изменится в ощущениях. 
        Введите правило «нового слова»: каждый день придумывайте новое слово для описания симптомов. 
        Найдите «зеркало» — человека, который будет пересказывать ваши разговоры о здоровье, пока вы не услышите себя со стороны.`
    },

    // 13. СМЕРТЬ
    "13": {
        positive: `Ваше здоровье требует разговоров о конце и возрождении. Вы говорите о симптомах как о сигналах смерти старого образа жизни. 
        Совместные практики: ритуальные прощания с болезнями, написание завещаний вредным привычкам, диалоги о том, что должно умереть для исцеления. 
        Вы не боитесь говорить о худшем — это снимает панику. Ваши разговоры очищают, как хирургический скальпель. 
        Тело чувствует эту готовность к трансформации и отдаёт болезнь без борьбы. Вы говорите правду, какой бы смертельной она ни была, 
        и это даёт жизнь новому здоровью.`,
        
        negative: `Вы говорите о здоровье только в тонах катастрофы. Каждый симптом — «конец света», каждый диагноз — «приговор». 
        Обсуждение превращается в взаимную истерику. Вы лечитесь не методами, а «прощанием с жизнью». Тело впадает в панику от ваших разговоров. 
        Вы убиваете надежду словами, ещё до того как болезнь сделает своё дело. Ваши диалоги — это похороны здоровья, которые вы проводите при живом теле. 
        Вы говорите о смерти так много, что она приходит по первому зову.`,
        
        advice: `Установите правило «смерти в 18:00»: все катастрофические разговоры о здоровье только до шести вечера, после — только планы на завтра. 
        Практикуйте «ритуал сожжения диагнозов»: пишите самые страшные слова о болезни на бумаге и сжигайте. 
        Создайте «книгу возрождения»: после каждого разговора о конце записывайте один вариант нового начала. 
        Найдите «проводника» — психолога, который поможет вам говорить о смерти, не умирая при этом.`
    },

    // 14. УМЕРЕННОСТЬ
    "14": {
        positive: `Ваше здоровье говорит на языке баланса и смешения. Вы находите золотую середину в обсуждении симптомов: 
        не отрицаете, но и не драматизируете. Совместные практики: диалоги, где один начинает фразу, другой заканчивает, 
        разговоры на стыке медицинского и метафорического языка. Вы умеете смешивать разные точки зрения в гармоничный коктейль. 
        Тело получает сбалансированные сигналы — не панику, но и не равнодушие. Ваши разговоры исцеляют уже тем, что происходят — 
        они поддерживают температурный баланс вашего общего здоровья.`,
        
        negative: `Ваши разговоры о здоровье — это бесконечные компромиссы, которые никого не устраивают. 
        Вы говорите так, чтобы не обидеть, не напугать, не взволновать — в результате не говорите ничего. 
        Лечение превращается в «ни то ни сё»: ни традиционная медицина, ни альтернативная, а что-то среднее, неэффективное. 
        Тело путается от этой полуправды. Вы лечитесь полумерами, потому что ваши диалоги не могут родить целостного решения. 
        Ваша коммуникация — это тёплая вода, которая не лечит и не калечит, просто течёт.`,
        
        advice: `Создайте «шкалу температуры разговора»: от 0 (холодные факты) до 10 (горячие эмоции), стремитесь к 5. 
        Практикуйте «диалог алхимика»: один говорит только факты, другой — только чувства, потом смешивайте. 
        Введите правило «целостного высказывания»: каждый должен закончить мысль, даже если она неприятна. 
        Найдите «балансира» — таймер, который напоминает, когда разговор слишком долго задерживается на одной крайности.`
    },

    // 15. ДЬЯВОЛ
    "15": {
        positive: `Ваше здоровье говорит на языке запретных тем. Вы обсуждаете симптомы, о которых обычно молчат: сексуальные дисфункции, 
        психические расстройства, постыдные болезни. Совместные практики: разговоры в темноте, признание самых тёмных страхов, 
        использование «неприличных» слов для описания ощущений. Вы срываете покровы табу с телесного опыта. 
        Тело благодарно за эту смелость — оно раскрывает свои самые потаённые секреты. Ваши диалоги освобождают энергию, 
        которая была связана стыдом, и эта энергия исцеляет.`,
        
        negative: `Вы упиваетесь «грязными» разговорами о здоровье. Симптомы становятся поводом для похабных шуток, 
        диагнозы — для циничных комментариев. Вы лечитесь не методами, а «разоблачением» медицины как обмана. 
        Обсуждение здоровья превращается в игру в правду-ложь, где нельзя доверять ни одному слову. Тело становится объектом ваших садистских шуток. 
        Вы связаны этим циничным диалогом как цепями — не можете говорить серьёзно, потому что это «немодно». 
        Ваша коммуникация — это чёрная дыра, где исчезает надежда на исцеление.`,
        
        advice: `Установите «священный час»: один час в неделю говорите о здоровье без цинизма и сарказма. 
        Практикуйте «ритуал обнажения»: по очереди называйте самый постыдный симптом, другой только кивает, не комментируя. 
        Создайте «шкаф для скелетов» — коробку, куда складываете записки с запретными темами, раз в месяц обсуждаете одну из них. 
        Найдите «проводника тьмы» — психотерапевта, который поможет вам говорить о тёмном, не погружаясь во тьму.`
    },

    // 16. БАШНЯ
    "16": {
        positive: `Ваше здоровье требует разговоров, которые рушат иллюзии. Вы говорите друг другу правду о симптомах, 
        какой бы разрушительной для ваших надежд она ни была. Совместные практики: диалоги во время кризиса, обсуждение худших сценариев, 
        словесные «взрывы» старых представлений о здоровье. Вы не боитесь разрушить своими словами хрупкое равновесие неведения. 
        Тело благодарно за эту правду — оно может начать исцеление только после краха иллюзий. Ваши разговоры — это молнии, 
        которые освещают болезнь такой, какая она есть, без прикрас.`,
        
        negative: `Ваши разговоры о здоровье — это серия катастроф. Каждый диалог заканчивается скандалом, каждое обсуждение — слезами. 
        Вы используете симптомы как оружие для разрушения друг друга: «ты и твоя семья — источник всех моих болезней». 
        Лечение невозможно, потому что каждый разговор рушит доверие. Тело содрогается от этих словесных землетрясений. 
        Вы лечитесь не методами, а взаимными обвинениями, которые только усугубляют стресс. Ваша коммуникация — это Башня, которая рушится каждый день.`,
        
        advice: `Создайте «бункер для разговоров»: специальное место, где можно говорить правду, не разрушая отношения. 
        Практикуйте «разговор на руинах»: после скандала садитесь среди беспорядка и говорите о симптомах тихо. 
        Введите правило «одной правды»: за один разговор говорите только одну разрушительную правду, остальное — поддерживающие слова. 
        Найдите «архитектора» — психолога, который поможет вам строить новые диалоги на руинах старых.`
    },

    // 17. ЗВЕЗДА
    "17": {
        positive: `Ваше здоровье говорит на языке надежды и вдохновения. Вы обсуждаете симптомы как временные затмения на пути к свету. 
        Совместные практики: разговоры под звёздным небом, составление карт желаний здоровья, диалоги о будущем, где болезней нет. 
        Ваши слова заряжены верой в лучшее. Тело откликается на эту веру, мобилизуя скрытые ресурсы. 
        Вы лечитесь не только лекарствами, но и красивыми историями о выздоровлении, которые создаёте вместе. 
        Ваши разговоры — это маяки в ночи болезни, которые показывают путь к берегу здоровья.`,
        
        negative: `Вы говорите о здоровье только в розовых тонах, отрицая реальность. «Всё будет хорошо» — ваша мантра, 
        даже когда анализы говорят обратное. Вы лечитесь не методами, а «позитивным мышлением», которое становится формой отрицания. 
        Тело кричит о помощи, но вы заглушаете его своими сладкими речами. Ваши диалоги — это побег в фантазии, 
        пока болезнь прогрессирует в реальности. Вы говорите о звёздах, но не замечаете, что тонете в болоте симптомов.`,
        
        advice: `Создайте «галерею надежды и реальности»: на одной стене размещайте оптимистичные прогнозы, на другой — реальные показатели здоровья. 
        Практикуйте «диалог двух голосов»: один говорит как мечтатель, другой — как реалист, потом меняйтесь. 
        Введите правило «звёздного часа»: час в день можно говорить только о хорошем, остальное время — полная честность. 
        Найдите «астронома» — врача, который поможет вам разглядеть реальные звёзды надежды, а не мираж.`
    },

    // 18. ЛУНА
    "18": {
        positive: `Ваше здоровье говорит на языке намёков и интуиции. Вы понимаете друг друга без слов, улавливая тончайшие нюансы в описании симптомов. 
        Совместные практики: разговоры во сне (с последующим обсуждением), диалоги при лунном свете, общение через метафоры и символы. 
        Вы доверяете подсознательным сообщениям тела больше, чем явным. Тело раскрывает вам тайны, которые никогда не сказало бы прямо. 
        Ваши разговоры полны поэзии, которая исцеляет душу, а через неё — и тело. Вы говорите как два медиума, принимающие сообщения от вашего общего бессознательного.`,
        
        negative: `Ваши разговоры о здоровье тонут в тумане недоговорённостей. Вы говорите намёками, которые никто не понимает, 
        обижаетесь, когда партнёр не расшифровал ваш симптом правильно. Лечение невозможно, потому что вы не можете договориться, 
        о чём вообще речь. Тело путается в этом полумраке. Вы лечитесь не методами, а «интуитивными прозрениями», которые часто оказываются ложными. 
        Ваши диалоги — это блуждание в лабиринте иллюзий, где каждый поворот ведёт в тупик.`,
        
        advice: `Создайте «лунный календарь разговоров»: обсуждайте здоровье только в определённые фазы луны. 
        Практикуйте «перевод с лунного»: один говорит метафорами, другой переводит на прямой язык, и наоборот. 
        Введите правило «утреннего протокола»: после интуитивных ночных разговоров утром составляйте чёткий план действий. 
        Найдите «переводчика снов» — психотерапевта, который поможет расшифровать ваши подсознательные сообщения о здоровье.`
    },

    // 19. СОЛНЦЕ
    "19": {
        positive: `Ваше здоровье говорит на языке ясности и радости. Вы обсуждаете симптомы прямо, без страха, с верой в хороший исход. 
        Совместные практики: диалоги на солнце, смех как терапия, разговоры о здоровье как о празднике жизни. 
        Ваши слова согревают и заряжают оптимизмом. Тело раскрывается навстречу этому солнечному свету, ускоряя выздоровление. 
        Вы лечитесь не только лекарствами, но и тёплыми беседами, которые напоминают, что жизнь прекрасна даже в болезни. 
        Ваши разговоры — это витамин D для души, который укрепляет иммунитет всего организма.`,
        
        negative: `Вы ослеплены своим оптимизмом. Говорите о здоровье только в сверкающих тонах, отрицая любые проблемы. 
        «Не ной», «все болезни от плохих мыслей» — ваши любимые фразы. Вы лечитесь не методами, а «солнечными ваннами» для души, 
        игнорируя реальные медицинские назначения. Тело страдает от этого яркого света, который не оставляет места тени для отдыха. 
        Ваши диалоги — это ослепительная вспышка, после которой вы не видите реальной картины болезни.`,
        
        advice: `Создайте «солнечные очки»: договоритесь, что каждый день 15 минут говорите о здоровье без прикрас, даже если это больно. 
        Практикуйте «закатный разговор»: обсуждайте симптомы на закате, когда свет мягкий и не ослепляет. 
        Введите правило «тени»: на каждый оптимистичный прогноз находите один реальный риск. 
        Найдите «солнечного врача» — специалиста, который сочетает оптимизм с реализмом.`
    },

    // 20. СУД
    "20": {
        positive: `Ваше здоровье требует разговоров о возрождении и прощении. Вы обсуждаете симптомы как призыв к новой жизни, 
        возможность начать с чистого листа. Совместные практики: диалоги-исповеди о прошлых ошибках в отношении здоровья, 
        ритуалы прощения себя и друг друга, разговоры о здоровье как о втором шансе. Ваши слова освобождают от груза вины за болезни. 
        Тело получает возможность исцелиться, потому что вы сняли с него проклятие «сам виноват». 
        Ваши разговоры — это трубный глас, пробуждающий спящие ресурсы организма.`,
        
        negative: `Ваши разговоры о здоровье — это постоянный суд над прошлым. Вы ищете виноватых в нынешних болезнях: 
        родители, стресс, экология — кто угодно, только не вы. Лечение откладывается, потому что «сначала нужно разобраться, кто виноват». 
        Тело страдает под тяжестью этого вечного суда. Вы лечитесь не методами, а «вынесением приговоров» своему прошлому. 
        Ваши диалоги — это зал суда, где нет адвокатов, только обвинители и подсудимые.`,
        
        advice: `Создайте «суд последней инстанции»: проведите один глобальный суд над всеми причинами болезней, вынесите вердикт и больше не возвращайтесь. 
        Практикуйте «разговор под амнистией»: обсуждайте здоровье, предварительно подписав соглашение о взаимном прощении. 
        Введите правило «нового дела»: вместо того чтобы судить прошлое, заведите «дело» на настоящее лечение. 
        Найдите «судью-примирителя» — медиатора, который поможет вам прекратить тяжбу с прошлым.`
    },

    // 21. МИР
    "21": {
        positive: `Ваше здоровье говорит на языке целостности и завершённости. Вы обсуждаете симптомы как часть великой картины вашей жизни, 
        не вырывая их из контекста. Совместные практики: диалоги о взаимосвязи всех аспектов здоровья, разговоры о здоровье как о танце всех систем организма, 
        общение, которое объединяет физическое, эмоциональное и духовное. Ваши слова создают гармонию, в которой болезнь находит своё место и теряет власть. 
        Тело чувствует эту целостность и начинает самовосстановление. Ваши разговоры — это симфония, где каждый симптом становится необходимой нотой.`,
        
        negative: `Ваши разговоры о здоровье застыли в самодовольной гармонии. Вы говорите о симптомах как о «неотъемлемой части прекрасного целого», 
        игнорируя их разрушительность. Лечение кажется ненужным, потому что «и так всё прекрасно в своей целостности». 
        Тело страдает от этого застоя. Вы лечитесь не методами, а «философскими беседами» о единстве всего сущего. 
        Ваши диалоги — это красивая картина, на которой вы не замечаете трещин, пока картина не рассыпается.`,
        
        advice: `Создайте «карту целостности с дырами»: отмечайте не только гармоничные аспекты здоровья, но и «дыры», требующие внимания. 
        Практикуйте «разговор на грани хаоса»: нарочно нарушайте гармонию, обсуждая симптомы резко и прямо, потом восстанавливайте равновесие. 
        Введите правило «диссонанса»: каждый день находите один аспект здоровья, который не вписывается в вашу идеальную картину. 
        Найдите «дирижёра» — врача, который поможет вам создать истинную гармонию, а не иллюзию.`
    },

    "22": {
        positive: `Ваше здоровье говорит на языке абсурда. Диагнозы, которые вы ставите друг другу, звучат как шутки, но оказываются пророческими. 
        Вы лечитесь смехом, превращая каждую болезнь в комедийный скетч. Ваши тела понимают язык игривых метафор: «грипп — это просто чих ангела». 
        Вы разрешаете себе говорить о симптомах несерьёзно, снимая панику. Совместные практики: кричальная терапия, пение бессмысленных звуков, 
        разговор на придуманном языке. Исцеление происходит, когда болезнь перестаёт быть трагедией и становится частью вашего творческого хаоса.`,
        
        negative: `Вы издеваетесь над реальными симптомами, пока они не становятся смертельными. «Просто притворись здоровым» — ваш девиз, 
        приводящий к запущенным состояниям. Один высмеивает жалобы другого, называя их симуляцией. Вы создаёте культ «весёлого больного», 
        где нельзя говорить о боли без шутки. Тело мстит молчанием, переставая подавать сигналы. Вы лечитесь анекдотами вместо лекарств, 
        пока болезнь не начинает смеяться над вами последней. Ваша коммуникация о здоровье — это поток едкого сарказма, разъедающий доверие.`,
        
        advice: `Установите правило «5 минут серьёзности»: каждый день говорите о симптомах без шуток, глядя в глаза. 
        Практикуйте «ритуал клоуна и врача»: один день вы клоун, преувеличивающий симптомы до абсурда, другой — врач, ставящий реальный диагноз. 
        Запишите все шутки о здоровье и перечитайте их вместе — отделите юмор от отрицания. 
        Создайте «язык тела»: придумайте три жеста, означающих «мне больно», «мне страшно», «мне нужна помощь» — используйте их, когда слова недоступны.`
    },

};