// === 1. ИМПОРТ ЛИЧНЫХ КОНТЕКСТОВ (SINGLE) ===
import { generalContent } from '/js/database/lichn/arcanas/general.js';
import { moneyContent } from '/js/database/lichn/arcanas/money.js';
import { relationsContent } from '/js/database/lichn/arcanas/relations.js';
import { healthContent } from '/js/database/lichn/arcanas/health.js';

// === 2. ИМПОРТ ФАЙЛОВ СОВМЕСТИМОСТИ (COMPAT) ===
import Ar1 from '/js/database/compat/arcanas/1_magician.js';
import Ar2 from '/js/database/compat/arcanas/2_high_priestess.js';
import Ar3 from '/js/database/compat/arcanas/3_empress.js';
import Ar4 from '/js/database/compat/arcanas/4_emperor.js';
import Ar5 from '/js/database/compat/arcanas/5_hierophant.js';
import Ar6 from '/js/database/compat/arcanas/6_lovers.js';
import Ar7 from '/js/database/compat/arcanas/7_chariot.js';
import Ar8 from '/js/database/compat/arcanas/8_justice.js';
import Ar9 from '/js/database/compat/arcanas/9_hermit.js';
import Ar10 from '/js/database/compat/arcanas/10_wheel_of_fortune.js';
import Ar11 from '/js/database/compat/arcanas/11_strength.js';
import Ar12 from '/js/database/compat/arcanas/12_hanged_man.js';
import Ar13 from '/js/database/compat/arcanas/13_death.js';
import Ar14 from '/js/database/compat/arcanas/14_temperance.js';
import Ar15 from '/js/database/compat/arcanas/15_devil.js';
import Ar16 from '/js/database/compat/arcanas/16_tower.js';
import Ar17 from '/js/database/compat/arcanas/17_star.js';
import Ar18 from '/js/database/compat/arcanas/18_moon.js';
import Ar19 from '/js/database/compat/arcanas/19_sun.js';
import Ar20 from '/js/database/compat/arcanas/20_judgment.js';
import Ar21 from '/js/database/compat/arcanas/21_world.js';
import Ar22 from '/js/database/compat/arcanas/22_fool.js';

const DEEP_ARCANAS = {
  1: Ar1, 2: Ar2, 3: Ar3, 4: Ar4, 5: Ar5, 6: Ar6, 7: Ar7, 8: Ar8, 9: Ar9, 10: Ar10,
  11: Ar11, 12: Ar12, 13: Ar13, 14: Ar14, 15: Ar15, 16: Ar16, 17: Ar17, 18: Ar18,
  19: Ar19, 20: Ar20, 21: Ar21, 22: Ar22
};

export const ARCANA_DATA = {};

// Функция для безопасного маппинга секций совместимости
const mapCompatSection = (secData) => {
    if(!secData) return null;
    return {
        plus: secData.positive || secData.plus,
        minus: secData.negative || secData.minus,
        advice: secData.warning 
            ? `${secData.advice}<br><br><b>⚠️ Предостережение:</b> ${secData.warning}` 
            : secData.advice
    };
};

for(let i=1; i<=22; i++) {
    // 1. Личные данные
    const gen = generalContent[i] || {};
    
    // 2. Данные совместимости
    const deep = DEEP_ARCANAS[i] || {};
    const deepGen = deep.general || {}; 

    const compatName = deep.archetype ? `${deep.name} — ${deep.archetype}` : (deep.name || gen.title);

    ARCANA_DATA[i] = {
        name: gen.title || `Аркан ${i}`,
        
        // === ЛИЧНЫЙ РЕЖИМ ===
        plus: gen.positive,
        minus: gen.negative,
        advice: gen.advice,
        
        // Контексты (личные)
        money: moneyContent[i] || {},
        relations: relationsContent[i] || {},
        health: healthContent[i] || {},

        // === РЕЖИМ СОВМЕСТИМОСТИ ===
        compat: {
            name: compatName, 
            
            // Общее описание
            plus: deepGen.positive || "Описание загружается...", 
            minus: deepGen.negative || "...", 
            advice: deepGen.warning 
                ? `${deepGen.advice}<br><br><b>⚠️ Предостережение:</b> ${deepGen.warning}` 
                : (deepGen.advice || "..."),
            
            // Специфичные секции (маппим их в стандартные ключи)
            money: mapCompatSection(deep.finance),    // finance -> money
            relations: mapCompatSection(deep.love),   // love -> relations
            family: mapCompatSection(deep.family)     // family -> family
        }
    };
}
