export const NEIGHBOR_MAP = {
  // === ЦЕНТР (Бывший E) ===
  Center: ['Pers_Levo_3','Pers_Verh_3','Pers_Pravo_3','Pers_Niz_3', 'Hor_L_Inn', 'Hor_R_Inn', 'Key_Inn'],

  // === КРЕСТ ЛИЧНОСТИ (Бывшие A, B, C, D) ===
  
  // День рождения (A)
  Pers_Levo_3:  ['Center','Pers_Verh_3','Pers_Niz_3','Rod_F_Verh_3','Rod_M_Niz_3','Hor_L_Inn','Hor_L_Mid','Hor_L_Out'],
  
  // Месяц / Талант (B)
  Pers_Verh_3:  ['Center','Pers_Levo_3','Pers_Pravo_3','Rod_F_Verh_3','Rod_M_Verh_3','Sky_Inn','Sky_Mid','Sky_Out'],
  
  // Год (C)
  Pers_Pravo_3: ['Center','Pers_Verh_3','Pers_Niz_3','Rod_M_Verh_3','Rod_F_Niz_3','Hor_R_Inn','Hor_R_Mid','Hor_R_Out'],
  
  // Низ / Кармический хвост (D)
  Pers_Niz_3:   ['Center','Pers_Levo_3','Pers_Pravo_3','Rod_F_Niz_3','Rod_M_Niz_3','Earth_Inn','Earth_Mid','Earth_Out'],

  // === РОДОВЫЕ УГЛЫ (Бывшие F, G, H, I) ===
  Rod_F_Verh_3: ['Pers_Levo_3','Pers_Verh_3','Rod_F_Verh_2','Rod_F_Verh_1','Purpose_Soc'],
  Rod_M_Verh_3: ['Pers_Verh_3','Pers_Pravo_3','Rod_M_Verh_2','Rod_M_Verh_1','Purpose_Soc'],
  Rod_F_Niz_3:  ['Pers_Pravo_3','Pers_Niz_3','Rod_F_Niz_2','Rod_F_Niz_1','Purpose_Soc'],
  Rod_M_Niz_3:  ['Pers_Niz_3','Pers_Levo_3','Rod_M_Niz_2','Rod_M_Niz_1','Purpose_Soc'],

  // === ЧАКРАЛЬНЫЙ СТОЛБ (Вертикаль) ===
  Sky_Inn:   ['Pers_Verh_3','Sky_Mid'],
  Sky_Mid:   ['Sky_Inn','Sky_Out','Pers_Verh_3'],
  Sky_Out:   ['Sky_Mid','Pers_Verh_3'],
  
  Earth_Inn: ['Pers_Niz_3','Earth_Mid'],
  Earth_Mid: ['Earth_Inn','Earth_Out','Pers_Niz_3'],
  Earth_Out: ['Earth_Mid','Pers_Niz_3'],

  // === ЛИНИЯ ЗЕМЛИ (Горизонталь) ===
  Hor_L_Inn: ['Pers_Levo_3','Hor_L_Mid','Center'],
  Hor_L_Mid: ['Hor_L_Inn','Hor_L_Out','Pers_Levo_3','Center'],
  Hor_L_Out: ['Hor_L_Mid','Pers_Levo_3'],

  Hor_R_Inn: ['Pers_Pravo_3','Hor_R_Mid','Center'],
  Hor_R_Mid: ['Hor_R_Inn','Hor_R_Out','Pers_Pravo_3','Center'],
  Hor_R_Out: ['Hor_R_Mid','Pers_Pravo_3'],

  // === КАНАЛЫ ДЕНЕГ И ОТНОШЕНИЙ ===
  // Точка входа в деньги
  Key_Money:    ['Pers_Pravo_2', 'Pers_Pravo_1', 'Key_Inn'],
  // Точка входа в отношения
  Key_Rel:      ['Pers_Niz_2', 'Pers_Niz_1', 'Key_Inn'],
  // Центр каналов (обычно под сердцем)
  Key_Inn:      ['Key_Money', 'Key_Rel', 'Center'],

  // === ПРЕДНАЗНАЧЕНИЯ ===
  Purpose_Pers: ['Pers_Levo_3','Pers_Verh_3','Pers_Pravo_3','Pers_Niz_3','Center'],
  Purpose_Soc:  ['Rod_F_Verh_3','Rod_M_Verh_3','Rod_F_Niz_3','Rod_M_Niz_3','Center']
};