(function() {
    var div = document.createElement('div');
    div.id = 'debug-console';
    div.style.cssText = 'position:fixed; top:0; left:0; width:100%; height:200px; background:rgba(0,0,0,0.9); color:#00FF00; z-index:99998; overflow-y:scroll; font-family:monospace; font-size:11px; border-bottom:1px solid #CCFF00; padding:10px 10px 30px 10px; pointer-events:none;';
    document.body.appendChild(div);

    // Кнопка COPY
    var copyBtn = document.createElement('button');
    copyBtn.textContent = '[ COPY LOGS ]';
    copyBtn.style.cssText = 'position:fixed; top:5px; right:5px; z-index:99999; background:#CCFF00; color:#000; border:none; padding:4px 8px; font-family:monospace; font-weight:bold; cursor:pointer; pointer-events:auto;';
    copyBtn.onclick = function() {
        var text = div.innerText;
        navigator.clipboard.writeText(text).then(() => {
            copyBtn.textContent = '[ COPIED! ]';
            setTimeout(() => copyBtn.textContent = '[ COPY LOGS ]', 2000);
        }).catch(err => {
            copyBtn.textContent = '[ ERROR ]';
            console.error('Copy failed', err);
        });
    };
    document.body.appendChild(copyBtn);

    function logToScreen(msg, color) {
        var p = document.createElement('div');
        p.textContent = '> ' + msg;
        p.style.borderBottom = '1px solid rgba(255,255,255,0.1)';
        p.style.padding = '2px 0';
        if (color) p.style.color = color;
        div.appendChild(p);
        div.scrollTop = div.scrollHeight;
    }

    window.onerror = function(msg, url, line) {
        logToScreen("CRITICAL: " + msg + " (Line: " + line + ")", '#FF4444');
        return false;
    };

    var oldLog = console.log;
    console.log = function() {
        var args = Array.from(arguments).map(String).join(' ');
        logToScreen(args);
        oldLog.apply(console, arguments);
    };

    var oldErr = console.error;
    console.error = function() {
        var args = Array.from(arguments).map(String).join(' ');
        logToScreen(args, '#FF4444');
        oldErr.apply(console, arguments);
    };
    
    console.log("LOGGER v2.0 ONLINE");
})();
