// Мы импортируем функцию расчета прямо с "сервера" (папка utils),
// но выполняем её здесь, в браузере.
import { generateNodes } from '/utils/matrixCore.js';

export async function calculate(date1, date2) {
    console.log('[API] Calculating locally:', date1, date2);
    
    // Оборачиваем в Promise для совместимости с кодом, который ждет await
    return new Promise((resolve, reject) => {
        try {
            // Мгновенный локальный расчет
            const result = generateNodes(date1, date2);
            
            // Имитируем небольшую задержку для плавности UI (опционально)
            setTimeout(() => {
                resolve(result);
            }, 50); 
            
        } catch (error) {
            console.error("[API] Calculation failed:", error);
            reject(error);
        }
    });
}
