// public/js/tech/modules/healthTableV2.js

// === 1. ИМПОРТЫ (Исправил пути на абсолютные и убрал опечатки) ===

// ЛИЧНЫЕ (Lichn)
import { HEALTH_lSahasrara }    from '/js/database/lichn/health/lichn-Sahasrara.js';
import { HEALTH_lAjna }         from '/js/database/lichn/health/lichn-Ajna.js';
import { HEALTH_lVishudha }     from '/js/database/lichn/health/lichn-Vishudha.js';
import { HEALTH_lAnahata }      from '/js/database/lichn/health/lichn-Anahata.js';
import { HEALTH_lManipura }     from '/js/database/lichn/health/lichn-Manipura.js';
import { HEALTH_lSvadhisthana } from '/js/database/lichn/health/lichn-Svadhisthana.js';
import { HEALTH_lMuladhara }    from '/js/database/lichn/health/lichn-Muladhara.js';

// СОВМЕСТИМОСТЬ (Compat)
import { HEALTH_cSahasrara }    from '/js/database/compat/health/compat-Sahasrara.js';
import { HEALTH_cAjna }         from '/js/database/compat/health/compat-Ajna.js';
import { HEALTH_cVishudha }     from '/js/database/compat/health/compat-Vishudha.js';
import { HEALTH_cAnahata }      from '/js/database/compat/health/compat-Anahata.js';
import { HEALTH_cManipura }     from '/js/database/compat/health/compat-Manipura.js';
import { HEALTH_cSvadhisthana } from '/js/database/compat/health/compat-Svadhisthana.js';
import { HEALTH_cMuladhara }    from '/js/database/compat/health/compat-Muladhara.js';

// === 2. КАРТА БАЗ ДАННЫХ ===
// Связываем техническое имя чакры (из расчета) с твоим файлом
const DB_MAP = {
    single: {
        'Sahasrara':    HEALTH_lSahasrara,
        'Ajna':         HEALTH_lAjna,
        'Vishudha':     HEALTH_lVishudha,
        'Anahata':      HEALTH_lAnahata,
        'Manipura':     HEALTH_lManipura,
        'Svadhisthana': HEALTH_lSvadhisthana,
        'Muladhara':    HEALTH_lMuladhara
    },
    compat: {
        'Sahasrara':    HEALTH_cSahasrara,
        'Ajna':         HEALTH_cAjna,
        'Vishudha':     HEALTH_cVishudha,
        'Anahata':      HEALTH_cAnahata,
        'Manipura':     HEALTH_cManipura,
        'Svadhisthana': HEALTH_cSvadhisthana,
        'Muladhara':    HEALTH_cMuladhara
    }
};

// Красивые названия для UI
const CHAKRA_NAMES = {
    'Sahasrara':    '7. САХАСРАРА (Дух)',
    'Ajna':         '6. АДЖНА (Голова)',
    'Vishudha':     '5. ВИШУДХА (Горло)',
    'Anahata':      '4. АНАХАТА (Сердце)',
    'Manipura':     '3. МАНИПУРА (Живот)',
    'Svadhisthana': '2. СВАДХИСТАНА (Секс)',
    'Muladhara':    '1. МУЛАДХАРА (Опора)'
};

// === 3. ФУНКЦИЯ ПОИСКА ТЕКСТА ===
// Теперь она принимает еще и chakraName, чтобы знать, в какой файл лезть
function getText(arcana, type, mode, chakraName) {
    // 1. Определяем режим (single/compat)
    const modeDB = DB_MAP[mode] || DB_MAP['single'];

    // 2. Ищем базу конкретной чакры (например, HEALTH_lAjna)
    const chakraDB = modeDB[chakraName];

    if (!chakraDB) {
        return `<span style="color:red">[ERR: No DB for ${chakraName}]</span>`;
    }

    // 3. Ищем описание для аркана
    // Сначала пробуем конкретный аркан, потом default
    const data = chakraDB[arcana] || chakraDB['default'];

    if (!data) return "...";
    
    return data[type] || "...";
}

// === 4. ГЛАВНЫЙ РЕНДЕР ===
export function renderHealthTableHTML(calcResult, mode = 'single') {
    const healthData = calcResult.Health; 
    const totals = calcResult.Health_Total;

    if (!healthData || !Array.isArray(healthData)) {
        return '<div style="padding:20px; color:#ff4444; font-family:Courier New;">[SYSTEM ERROR]: NO HEALTH DATA</div>';
    }

    let rowsHTML = '';

    healthData.forEach((row, index) => {
        const { name, phys, en, res } = row;
        const ruName = CHAKRA_NAMES[name] || name;

        // ВАЖНО: Передаем имя чакры (row.name), чтобы найти нужный файл
        const descPlus = getText(res, 'positive', mode, name);
        const descMinus = getText(res, 'negative', mode, name);
        const descAdvice = getText(res, 'advice', mode, name);

        rowsHTML += `
            <div class="ch-row" onclick="this.classList.toggle('active')">
                <div class="ch-cell-name">${ruName}</div>
                <div class="ch-cell-val">${phys}</div>
                <div class="ch-cell-val">${en}</div>
                <div class="ch-cell-res">${res}</div>
            </div>
            <div class="ch-details">
                <div class="ch-desc-block"><span class="ch-label ch-plus">[+]</span> ${descPlus}</div>
                <div class="ch-desc-block"><span class="ch-label ch-minus">[-]</span> ${descMinus}</div>
                <div class="ch-desc-block"><span class="ch-label ch-advice">[i]</span> ${descAdvice}</div>
            </div>
        `;
    });

    const tPhys = totals ? totals.phys : '-';
    const tEn = totals ? totals.en : '-';
    const tRes = totals ? totals.res : '-';

    const totalHTML = `
        <div class="ch-total-row">
            <div class="ch-cell-name" style="color:#C6FF00">ИТОГО</div>
            <div class="ch-cell-val" style="color:#fff">${tPhys}</div>
            <div class="ch-cell-val" style="color:#fff">${tEn}</div>
            <div class="ch-cell-res">${tRes}</div>
        </div>
    `;

    const title = (mode === 'compat') ? 'МАТРИЦА ЗДОРОВЬЯ (ПАРНАЯ)' : 'МАТРИЦА ЗДОРОВЬЯ (ЛИЧНАЯ)';

    return `
        <div class="cyber-health-wrap">
            <h2 class="zone-title" style="font-size:12px; letter-spacing:2px; margin-bottom:15px; color:#fff; border-left:3px solid #C6FF00; padding-left:10px;">
                ${title}
            </h2>
            <div class="ch-header">
                <div>СИСТЕМА</div>
                <div style="text-align:center">ФИЗ</div>
                <div style="text-align:center">ЭНЕ</div>
                <div style="text-align:center">ИТОГ</div>
            </div>
            ${rowsHTML}
            ${totalHTML}
        </div>
    `;
}