export function initLiveReload() {
  // Без лог-спама. Работает как “тихий” детектор изменений статических файлов.
  const urls = [
    '/style/style.css',
    '/js/tech/app.js',
    '/js/tech/modules/ui.js'
  ];

  let last = null;

  async function head(u) {
    try {
      const r = await fetch(u, { method: 'HEAD', cache: 'no-store' });
      return (r.headers.get('etag') || r.headers.get('last-modified') || '') + ':' + u;
    } catch {
      return 'err:' + u;
    }
  }

  async function tick() {
    const parts = await Promise.all(urls.map(head));
    const now = parts.join('|');
    if (last && now !== last) location.reload();
    last = now;
  }

  tick();
  setInterval(tick, 1500);
}
