import { calculate } from './api.js';

// === ФУНКЦИЯ ОТРИСОВКИ (Перенесена сюда, чтобы удалить renderer.js) ===
function drawMatrix(nodes) {
  const box = document.getElementById('matrixContainer');
  if (!box) return;
  box.innerHTML = '';

  (nodes || []).forEach(n => {
    // Пропускаем пустые или служебные узлы
    if (!n.val || n.x < 0) return;

    const el = document.createElement('div');
    el.className = 'matrix-num';
    el.textContent = n.val;
    el.setAttribute('data-id', n.id);

    // Координаты
    el.style.left = `${n.x}px`;
    el.style.top  = `${n.y}px`;
    
    // Подсветка ключевых точек
    const specialIds = [
      'Budget_odin', 'Lubov_odin', 'Obshee', 'Strah', 'Radost',
      'Purpose_Pers', 'Purpose_Soc'
    ];

    if (specialIds.includes(n.id)) {
        el.style.color = 'var(--accent)'; 
        el.style.zIndex = '20';
        el.style.fontWeight = '900';
        el.style.fontSize = '12px';
    }

    box.appendChild(el);
  });
}

// === ГЛАВНАЯ ФУНКЦИЯ ===
export async function renderMatrix(d1, d2) {
  // 1. Считаем цифры
  const data = await calculate(d1, d2);
  
  const nodes = data.nodes || [];
  const meta = data.meta || {};

  // 2. Рисуем кружочки (функция теперь внутри этого файла)
  drawMatrix(nodes);

  // 3. Отдаем данные дальше (для UI и текстов)
  return { nodes, meta };
}
