export function initScrollFx() {
  const scroller = document.getElementById('scrollLayer'); // Убедись, что ID верный (в index.html я его не нашел, возможно это body или .sheet-body)
  const parallax = document.getElementById('parallaxWrapper'); // Тоже проверь ID
  const controls = document.getElementById('controls');
  
  // Если элементов нет — выходим молча, чтобы не спамить в консоль
  if (!scroller || !parallax) return;

  let ticking = false;

  const onScroll = () => {
    if (!ticking) {
      window.requestAnimationFrame(() => {
        const scrollTop = scroller.scrollTop || 0;
        
        // Логика параллакса
        const progress = Math.min(scrollTop / 420, 1);
        
        // Используем translate3d для включения GPU-ускорения
        parallax.style.transform = `translate3d(0, ${-(progress * 150)}px, 0) scale(${1 - (progress * 0.20)})`;
        parallax.style.opacity = String(1 - (progress * 0.30));

        if (controls) {
          const op = Math.max(0, 1 - (scrollTop / 160));
          controls.style.opacity = String(op);
          controls.style.pointerEvents = op <= 0.10 ? 'none' : 'auto';
        }

        ticking = false;
      });
      ticking = true;
    }
  };

  scroller.addEventListener('scroll', onScroll, { passive: true });
}
