const reduce = (n) => {
  let v = Math.abs(parseInt(n) || 0);
  while (v > 22) {
    v = v.toString().split('').reduce((a, b) => parseInt(a) + parseInt(b), 0);
  }
  return v === 0 ? 22 : v;
};

const sum = (a, b) => reduce(a + b);

export function calculateCompat(vals1, vals2) {
  // === 1. СОВМЕСТНЫЙ РОМБ (Базовые точки) ===
  const A = sum(vals1['Pers_Levo_3'], vals2['Pers_Levo_3']); // ЛЕВО (Общее)
  const B = sum(vals1['Pers_Verh_3'], vals2['Pers_Verh_3']); // ВЕРХ (Общий)
  const C = sum(vals1['Pers_Pravo_3'], vals2['Pers_Pravo_3']); // ПРАВО (Общее)
  const D = sum(vals1['Pers_Niz_3'], vals2['Pers_Niz_3']);   // НИЗ (Общий)
  const E = sum(vals1['Center'], vals2['Center']);           // ЦЕНТР (Главная энергия)

  // === 2. ВНУТРЕННИЕ ЛИНИИ (Пересчет для пары) ===
  
  // ЛЕВО (Линия Портрета)
  const A_Inner = sum(A, E);     
  const A_Mid   = sum(A, A_Inner);

  // ВЕРХ (Линия Вдохновения)
  const B_Inner = sum(B, E); 
  const B_Mid   = sum(B, B_Inner);

  // ПРАВО (Линия Денег)
  const C_Inner = sum(C, E);
  const C_Mid   = sum(C, C_Inner);

  // НИЗ (Линия Отношений)
  const D_Inner = sum(D, E);
  const D_Mid   = sum(D, D_Inner);

  // === 3. СОВМЕСТНЫЙ КВАДРАТ РОДА ===
  // Углы квадрата = Сумма вершин совместного ромба
  const TL = sum(B, A); // Верх-Лево
  const TR = sum(B, C); // Верх-Право
  const BR = sum(D, C); // Низ-Право
  const BL = sum(D, A); // Низ-Лево

  // ЭНЕРГИЯ РОДА (Сумма 4 углов)
  const Rod_Energy = reduce(TL + TR + BR + BL);

  // === ЛИНИИ РОДА ===
  // Мужская линия (Male): Верхний Левый (TL) -> Нижний Правый (BR)
  // В твоем шаблоне координаты TL/BR привязаны к ключам Rod_M
  const Male_Top_Inner = sum(TL, Rod_Energy);
  const Male_Top_Mid   = sum(TL, Male_Top_Inner);
  
  const Male_Bot_Inner = sum(BR, Rod_Energy);
  const Male_Bot_Mid   = sum(BR, Male_Bot_Inner);

  // Женская линия (Female): Верхний Правый (TR) -> Нижний Левый (BL)
  // В твоем шаблоне координаты TR/BL привязаны к ключам Rod_F
  const Female_Top_Inner = sum(TR, Rod_Energy);
  const Female_Top_Mid   = sum(TR, Female_Top_Inner);

  const Female_Bot_Inner = sum(BL, Rod_Energy);
  const Female_Bot_Mid   = sum(BL, Female_Bot_Inner);

  // === 4. ДЕНЬГИ И ЛЮБОВЬ ПАРЫ ===
  // Точка входа = Внутренняя Денег + Внутренняя Отношений
  const Obshee = sum(C_Inner, D_Inner);

  // Совместные Деньги = Точка Денег + Вход
  const Budget_odin = sum(C_Inner, Obshee);
  
  // Совместная Любовь = Точка Отношений + Вход
  const Lubov_odin  = sum(D_Inner, Obshee);

  // === 5. ДОПОЛНИТЕЛЬНЫЕ ТОЧКИ ===
  const Sex    = sum(E, Rod_Energy); // Сексуальность
  const Strah  = sum(E, B_Inner);          // Страх (Центр + Верх)
  const Radost = sum(E, A_Inner);          // Радость (Центр + Лево)

  // === 6. ПРЕДНАЗНАЧЕНИЕ ПАРЫ ===
  // Личное
  const Sky = sum(B, D);   // Небо
  const Earth = sum(A, C); // Земля
  const Pur_Pers = sum(Sky, Earth);

  // Социальное
  // Мужская линия (TL + BR)
  const Male_Line_Sum = sum(TL, BR);
  // Женская линия (TR + BL)
  const Female_Line_Sum = sum(TR, BL);
  
  const Pur_Soc = sum(Male_Line_Sum, Female_Line_Sum);

  // Общее (Духовное)
  const Pur_Gen = sum(Pur_Pers, Pur_Soc);

  // === 7. ЗДОРОВЬЕ ПАРЫ (ЧАКРЫ) ===
  const h1 = Array.isArray(vals1.Health) ? vals1.Health : [];
  const h2 = Array.isArray(vals2.Health) ? vals2.Health : [];
  
  const healthTable = h1.map((row1, index) => {
    const row2 = h2[index] || { phys: 0, en: 0 };
    
    // Колонка 1: Физика 1 + Физика 2
    const phys = sum(row1.phys, row2.phys);
    
    // Колонка 2: Энергия 1 + Энергия 2
    const en = sum(row1.en, row2.en);
    
    // Колонка 3: Итог (Phys + En)
    const res = sum(phys, en);

    return { name: row1.name, phys, en, res };
  });

  // Итого по столбцам здоровья
  const totalPhys = reduce(healthTable.reduce((acc, row) => acc + row.phys, 0));
  const totalEn   = reduce(healthTable.reduce((acc, row) => acc + row.en, 0));
  const totalRes  = sum(totalPhys, totalEn);

  return {
    'Center': E,
    'Pers_Levo_3': A, 'Pers_Levo_2': A_Inner, 'Pers_Levo_1': A_Mid,
    'Pers_Verh_3': B, 'Pers_Verh_2': B_Inner, 'Pers_Verh_1': B_Mid,
    'Pers_Pravo_3': C, 'Pers_Pravo_2': C_Inner, 'Pers_Pravo_1': C_Mid, 
    'Pers_Niz_3': D,   'Pers_Niz_2': D_Inner,   'Pers_Niz_1': D_Mid,
    
    // Женская линия (TR -> BL) -> пишет в Rod_F (геометрически верно)
    'Rod_F_Verh_3': TR, 'Rod_F_Verh_2': Female_Top_Inner, 'Rod_F_Verh_1': Female_Top_Mid,
    'Rod_F_Niz_3': BL,  'Rod_F_Niz_2': Female_Bot_Inner,  'Rod_F_Niz_1': Female_Bot_Mid,

    // Мужская линия (TL -> BR) -> пишет в Rod_M (геометрически верно)
    'Rod_M_Verh_3': TL, 'Rod_M_Verh_2': Male_Top_Inner, 'Rod_M_Verh_1': Male_Top_Mid,
    'Rod_M_Niz_3': BR,  'Rod_M_Niz_2': Male_Bot_Inner,  'Rod_M_Niz_1': Male_Bot_Mid,

    'Purpose_Pers': Pur_Pers, 'Purpose_Soc': Pur_Soc, 'Purpose_Gen': Pur_Gen,
    'Budget_odin': Budget_odin, 'Lubov_odin': Lubov_odin,
    'Obshee': Obshee, 
    'Strah': Strah, 'Radost': Radost, 'Sex': Sex, 'Rod_Energy': Rod_Energy,
    
    'Health': healthTable,
    'Health_Total': { phys: totalPhys, en: totalEn, res: totalRes }
  };
}