// --- МАТЕМАТИКА ЛИЧНОЙ МАТРИЦЫ (BLACK OBSIDIAN / DESTINY PROTOCOL) ---

// Функция свертки: числа > 22 складываются до тех пор, пока не станут <= 22
const reduce = (n) => {
  let v = Math.abs(parseInt(n) || 0);
  while (v > 22) {
    v = v.toString().split('').reduce((a, b) => parseInt(a) + parseInt(b), 0);
  }
  return v === 0 ? 22 : v;
};

const sum = (a, b) => reduce(a + b);

export function calculatePersonal(d, m, y) {
  // === 1. БАЗОВЫЙ КРЕСТ (РОМБ) ===
  const A = reduce(d); // ЛЕВО (День / Портрет)
  const B = reduce(m); // ВЕРХ (Месяц / Талант)
  const C = reduce(y.split('').reduce((a, b) => +a + (+b), 0)); // ПРАВО (Год / Материя)
  
  // НИЗ: Сумма трех предыдущих (Лево + Верх + Право)
  const D = reduce(A + B + C); 

  // ЦЕНТР (Точка комфорта): Сумма всех 4-х
  const E = reduce(A + B + C + D); 

  // === 2. ЛИНИИ (ЧАКРЫ) ===
  // Логика переписана под твой запрос:
  // 1. Внутренняя точка (ближе к центру) = Угол + Центр
  // 2. Средняя точка (ближе к краю) = Угол + Внутренняя точка
  
  // ЛЕВО (Линия Я)
  const A_Inner = sum(A, E);     // Внутренняя (ближе к центру)
  const A_Mid   = sum(A, A_Inner); // Средняя

  // ВЕРХ (Линия Неба)
  const B_Inner = sum(B, E); 
  const B_Mid   = sum(B, B_Inner);

  // ПРАВО (Линия Денег)
  const C_Inner = sum(C, E);
  const C_Mid   = sum(C, C_Inner);

  // НИЗ (Линия Кармы)
  const D_Inner = sum(D, E);
  const D_Mid   = sum(D, D_Inner);

  // === 3. РОДОВОЙ КВАДРАТ (КВАДРАТ) ===
  // Углы квадрата
  const TL = sum(A, B); // Верх-Лево
  const TR = sum(B, C); // Верх-Право
  const BR = sum(C, D); // Низ-Право
  const BL = sum(D, A); // Низ-Лево

  // ЭНЕРГИЯ РОДА (Сумма 4 углов квадрата)
  // В твоем примере: 15+12+7+10 = 44 -> 8
  const Rod_Energy = reduce(TL + TR + BR + BL);

  // Расчет линий Рода по твоей логике:
  // "Точка рядом с краем (Внутренняя для Рода) = Угол + Энергия Рода"
  // "Точка посередине = Угол + Точка рядом с краем"
  
  // Линия ОТЦА: Верх-Право (TR) -> Низ-Лево (BL)
  const F_Top_Inner = sum(TR, Rod_Energy); 
  const F_Top_Mid   = sum(TR, F_Top_Inner);
  
  const F_Bot_Inner = sum(BL, Rod_Energy);
  const F_Bot_Mid   = sum(BL, F_Bot_Inner);

  // Линия МАТЕРИ: Верх-Лево (TL) -> Низ-Право (BR)
  const M_Top_Inner = sum(TL, Rod_Energy);
  const M_Top_Mid   = sum(TL, M_Top_Inner);

  const M_Bot_Inner = sum(BR, Rod_Energy);
  const M_Bot_Mid   = sum(BR, M_Bot_Inner);

  // === 4. КАНАЛЫ (ДЕНЬГИ И ЛЮБОВЬ) ===
  // Вход (Общее) = Внутренняя точка Денег + Внутренняя точка Кармы
  const Obshee = sum(C_Inner, D_Inner); 
  
  const Budget_odin = sum(C_Inner, Obshee); // Деньги
  const Lubov_odin  = sum(D_Inner, Obshee); // Любовь

  // === 5. ТОЧКИ СОСТОЯНИЯ ===
  const Strah  = sum(E, B_Inner); // Страх = Центр + Верх Внутр
  const Radost = sum(E, A_Inner); // Радость = Центр + Лево Внутр
  const Sex    = sum(E, Rod_Energy); // Сексуальность = Центр + Энергия Рода

  // === 6. ПРЕДНАЗНАЧЕНИЯ ===
  // Личное
  const Sky   = sum(B, D); // Небо (Верх + Низ)
  const Earth = sum(A, C); // Земля (Лево + Право)
  const Pur_Pers = sum(Sky, Earth); // Личное (без центра)

  // Социальное
  const Male   = sum(TL, BR); // Мужское (TL + BR)
  const Female = sum(TR, BL); // Женское (TR + BL)
  const Pur_Soc = sum(Male, Female);

  // Общее (Духовное)
  const Pur_Gen = sum(Pur_Pers, Pur_Soc);

  // === 7. КАРТА ЗДОРОВЬЯ (ЧАКРЫ) ===
  // Формируем таблицу 7 строк
  // Колонка 1 (Физика): Слева направо по горизонтали (Земля), но Верх (7) исключение
  // Колонка 2 (Энергия): Сверху вниз по вертикали (Небо)
  
  // Паттерн на основе твоего примера:
  // 7 (Сахасрара): Небо(7) | Земля(8) | Сумма
  // 6 (Аджна):     Земля_Mid | Небо_Mid | Сумма
  // 5 (Вишудха):   Земля_Inner | Небо_Inner | Сумма
  // 4 (Анахата):   Радость | Страх | Сумма
  // 3 (Манипура):  Центр | Центр | Сумма
  // 2 (Свадхист.): Земля_Inner_Right | Небо_Inner_Bot | Сумма
  // 1 (Муладхара): Земля_Right | Небо_Bot | Сумма

  // *Примечание: в твоем примере строка 7 (7|8) выбивается из логики "Слева направо", 
  // так как 7 - это верх, а 8 - лево. Я следую твоему примеру чисел.*

  const healthTable = [
    { name: 'Sahasrara', phys: B, en: A, res: sum(B, A) },       // Row 7
    { name: 'Ajna',      phys: A_Mid, en: B_Mid, res: sum(A_Mid, B_Mid) }, // Row 6
    { name: 'Vishudha',  phys: A_Inner, en: B_Inner, res: sum(A_Inner, B_Inner) }, // Row 5
    { name: 'Anahata',   phys: Radost, en: Strah, res: sum(Radost, Strah) }, // Row 4
    { name: 'Manipura',  phys: E, en: E, res: sum(E, E) },       // Row 3
    { name: 'Svadhisthana', phys: C_Inner, en: D_Inner, res: sum(C_Inner, D_Inner) }, // Row 2
    { name: 'Muladhara', phys: C, en: D, res: sum(C, D) }        // Row 1
  ];

  // Сумма столбцов (Итого)
  const totalPhys = reduce(healthTable.reduce((acc, row) => acc + row.phys, 0));
  const totalEn   = reduce(healthTable.reduce((acc, row) => acc + row.en, 0));
  const totalRes  = sum(totalPhys, totalEn);

  return {
    'Center': E,
    'Pers_Levo_3': A, 'Pers_Levo_2': A_Inner, 'Pers_Levo_1': A_Mid,
    'Pers_Verh_3': B, 'Pers_Verh_2': B_Inner, 'Pers_Verh_1': B_Mid,
    'Pers_Pravo_3': C, 'Pers_Pravo_2': C_Inner, 'Pers_Pravo_1': C_Mid, 
    'Pers_Niz_3': D,   'Pers_Niz_2': D_Inner,   'Pers_Niz_1': D_Mid,
    
    // Род ОТЦА (TR -> BL)
    'Rod_F_Verh_3': TR, 'Rod_F_Verh_2': F_Top_Inner, 'Rod_F_Verh_1': F_Top_Mid,
    'Rod_F_Niz_3': BL,  'Rod_F_Niz_2': F_Bot_Inner,  'Rod_F_Niz_1': F_Bot_Mid,

    // Род МАТЕРИ (TL -> BR)
    'Rod_M_Verh_3': TL, 'Rod_M_Verh_2': M_Top_Inner, 'Rod_M_Verh_1': M_Top_Mid,
    'Rod_M_Niz_3': BR,  'Rod_M_Niz_2': M_Bot_Inner,  'Rod_M_Niz_1': M_Bot_Mid,

    'Purpose_Pers': Pur_Pers, 'Purpose_Soc': Pur_Soc, 'Purpose_Gen': Pur_Gen,
    'Budget_odin': Budget_odin, 'Lubov_odin': Lubov_odin,
    'Obshee': Obshee, 
    'Strah': Strah, 'Radost': Radost, 'Sex': Sex, 'Rod_Energy': Rod_Energy,
    
    'Health': healthTable,
    'Health_Total': { phys: totalPhys, en: totalEn, res: totalRes }
  };
}