import { calculatePersonal } from './calcPersonal.js';
import { calculateCompat } from './calcCompat.js';

// 1. СЛОВАРЬ КООРДИНАТ (DESTINY PROTOCOL)
const COORDS = {
  // === ЦЕНТР ===
  'Center': { x: 150, y: 150 },

  // === ЛИЧНЫЙ КВАДРАТ (ДИАГОНАЛЬ) ===
  'Pers_Verh_3': { x: 150, y: 19 },   // B
  'Pers_Verh_1': { x: 150, y: 43 },
  'Pers_Verh_2': { x: 150, y: 62.5 },

  'Pers_Niz_3':  { x: 150, y: 281 },   // D
  'Pers_Niz_1':  { x: 150, y: 257 },
  'Pers_Niz_2':  { x: 150, y: 237.5 },

  'Pers_Levo_3': { x: 19,   y: 150 }, // A
  'Pers_Levo_1': { x: 45,   y: 150 },
  'Pers_Levo_2': { x: 62.5, y: 150 },

  'Pers_Pravo_3': { x: 283.5, y: 150 }, // C
  'Pers_Pravo_1': { x: 256.5, y: 150 },
  'Pers_Pravo_2': { x: 237.5, y: 150 },

  // === РОДОВОЙ КВАДРАТ ===
  // Род ОТЦА (Верх TR -> Низ BL)
  'Rod_F_Verh_3': { x: 242,   y: 56 },   
  'Rod_F_Verh_1': { x: 223.5, y: 74.5 }, 
  'Rod_F_Verh_2': { x: 210.5, y: 88 },   

  'Rod_F_Niz_3':  { x: 55.6, y: 244 },  
  'Rod_F_Niz_1':  { x: 74.5, y: 224.5 }, 
  'Rod_F_Niz_2':  { x: 88.5, y: 210.5 }, 

  // Род МАТЕРИ (Верх TL -> Низ BR)
  'Rod_M_Verh_3': { x: 57,   y: 56.5 },  
  'Rod_M_Verh_1': { x: 75.5, y: 75.5 },  
  'Rod_M_Verh_2': { x: 88,   y: 88 },    

  'Rod_M_Niz_3':  { x: 244,   y: 244 }, 
  'Rod_M_Niz_1':  { x: 225,   y: 225 },   
  'Rod_M_Niz_2':  { x: 212.5, y: 212.5 },   

  // === КАНАЛЫ И ТОЧКИ ===
  'Budget_odin': { x: 203.7, y: 175 },   
  'Lubov_odin':  { x: 175,   y: 203.3 }, 
  'Obshee':      { x: 190,   y: 190 },   

  'Strah':       { x: 150,   y: 103 },   
  'Radost':      { x: 103,   y: 150 },   
  'Sex':         { x: 190,   y: 150 },
  'Rod_Energy':  { x: 175,   y: 150 },

  // === ПРЕДНАЗНАЧЕНИЯ (ВАЖНО: ДОБАВЛЕНО) ===
  // Мы даем им координаты -9999, чтобы они попали в массив nodes,
  // но не рисовались на самой картинке матрицы (или можно 0,0)
  'Purpose_Pers':   { x: -9999, y: -9999 },
  'Purpose_Soc':    { x: -9999, y: -9999 },
  'Purpose_Gen':    { x: -9999, y: -9999 },
  // На случай, если в UI используется ключ Purpose_Spirit
  'Purpose_Spirit': { x: -9999, y: -9999 }
};

// ГЕНЕРАЦИЯ
export function generateNodes(dateStr, dateStr2 = null) {
  if (!dateStr) return { nodes: [], meta: {} };

  const [y, m, d] = dateStr.split('-');
  let vals = calculatePersonal(d, m, y);

  if (dateStr2) {
    const [y2, m2, d2] = dateStr2.split('-');
    const vals2 = calculatePersonal(d2, m2, y2);
    vals = calculateCompat(vals, vals2);
  }

  // Если ui.js ждет Spirit, а расчет дает Gen - делаем дубль
  if(vals.Purpose_Gen && !vals.Purpose_Spirit) {
      vals.Purpose_Spirit = vals.Purpose_Gen;
  }

  const nodes = [];
  Object.keys(vals).forEach(key => {
    const coord = COORDS[key];
    if (coord) {
        nodes.push({ 
            id: key, 
            val: vals[key], 
            x: coord.x, 
            y: coord.y 
        });
    }
  });

  return { nodes, meta: { values: vals } };
}